#!/usr/bin/env bash
set -e

echo "`date -Iseconds` Providing access to logs and smarty directories..."
mkdir -p /code/ow_log /code/ow_smarty/template_c
chown www-data:www-data /code/ow_log /code/ow_smarty/template_c

touch /etc/nginx/.htpasswd
if [[ $NGINX_USER && $NGINX_PASSWORD_HASH ]]; then
  echo "$NGINX_USER:$NGINX_PASSWORD_HASH" >> /etc/nginx/.htpasswd
fi

echo "Starting php7.3-fpm..."
php-fpm7.3
echo "Starting nginx service..."
nginx -g "daemon off;"
