#!/usr/bin/env bash
# In the name of Allah
# This script is used to create symbolic links for plugin and theme static files in the ow_static directory

if [[ "$1" == "" || "$3" == "" ]]; then
  echo "Usage: update-statics.sh <src> </src_sub_path> <dst> [<filters>]" >&2
  exit 1
fi

src=$1
src_sub_path=$2
dst=$3
filters=$4

dirs=`find $src -maxdepth 1 -mindepth 1 -type d $filters -printf '%f\n'`
echo "$dirs" | while read -r dir; do
  if [ -d "${src}/${dir}${src_sub_path}" ]; then
    ln -sf ${src}/${dir}${src_sub_path} ${dst}/${dir}
  fi
done
