<?php
$dbPrefix = OW_DB_PREFIX;

if ( !OW::getConfig()->configExists('blogs', 'results_per_page') )
{
    OW::getConfig()->addConfig('blogs', 'results_per_page', 10, 'Post number per page');
}

if ( !OW::getConfig()->configExists('blogs', 'uninstall_inprogress') )
{
    OW::getConfig()->addConfig('blogs', 'uninstall_inprogress', 0, '');
}

if ( !OW::getConfig()->configExists('blogs', 'uninstall_cron_busy') )
{
    OW::getConfig()->addConfig('blogs', 'uninstall_cron_busy', 0, '');
}

$authorization = OW::getAuthorization();
$groupName = 'blogs';
$authorization->addGroup($groupName);
$authorization->addAction($groupName, 'add_comment');
$authorization->addAction($groupName, 'add');
$authorization->addAction($groupName, 'view', true);

OW::getDbo()->query("
DROP TABLE IF EXISTS `{$dbPrefix}blogs_post`;");

$sql =
    <<<EOT

CREATE TABLE IF NOT EXISTS `{$dbPrefix}blogs_post` (
  `id` INTEGER(11) NOT NULL AUTO_INCREMENT,
  `authorId` INTEGER(11) NOT NULL,
  `title` VARCHAR(512) COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `post` TEXT COLLATE utf8_general_ci NOT NULL,
  `timestamp` INTEGER(11) NOT NULL,
  `isDraft` TINYINT(1) NOT NULL,
  `privacy` varchar(50) NOT NULL default 'everybody',
  PRIMARY KEY (`id`),
  KEY `authorId` (`authorId`)
)DEFAULT CHARSET=utf8;

EOT;

OW::getDbo()->query($sql);
