<?php
$config = OW::getConfig();
if ( !$config->configExists('iissecurityessentials', 'privacyUpdateNotification') )
{
    $config->addConfig('iissecurityessentials', 'privacyUpdateNotification', false);
}

$languageService = Updater::getLanguageService();

$languages = $languageService->getLanguages();
$langEnId = null;
$langFaId = null;
foreach ($languages as $lang) {
    if ($lang->tag == 'fa-IR') {
        $langFaId = $lang->id;
    }
    if ($lang->tag == 'en') {
        $langEnId = $lang->id;
    }
}

if ($langFaId != null) {
    $languageService->addOrUpdateValue($langFaId, 'iissecurityessentials', 'privacyUpdateNotification', 'فعال بودن اعلان به‌روزرسانی تنظیمات حریم خصوصی');
}
if ($langEnId != null) {
    $languageService->addOrUpdateValue($langEnId, 'iissecurityessentials', 'privacyUpdateNotification', 'Privacy settings update notification');
}
