<?php
/**
 * iisactivitylimit
 */
/**
 * @author Issa Annamoradnejad <i.moradnejad@gmail.com>
 * @package ow_plugins.iisactivitylimit
 * @since 1.0
 */

class IISACTIVITYLIMIT_CLASS_EventHandler
{
    private static $classInstance;

    public static function getInstance()
    {
        if (self::$classInstance === null) {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    private function __construct()
    {
    }

    public function init()
    {
        OW::getEventManager()->bind(IISEventManager::AFTER_USER_QUERY_EXECUTED, array($this, 'onAfterUserQueryExecuted'));
        OW::getEventManager()->bind(OW_EventManager::ON_APPLICATION_INIT, array($this, 'onApplicationInit'));
    }

    public function onAfterUserQueryExecuted(OW_Event $event)
    {
        $tableName = $event->getParams()['table_name'];
        if(isset($GLOBALS['iisactivitylimit_skip']) && !$GLOBALS['iisactivitylimit_skip'] &&
            !in_array($tableName , [
                'iisactivitylimit_user_requests', 'base_user_online', 'mailbox_user_last_data',
                'base_user', 'newsfeed_action_set', 'iisuserlogin_active_details'
            ])
        ){
            IISACTIVITYLIMIT_BOL_Service::getInstance()->increaseCountDBForCurrentUser();
            $GLOBALS['iisactivitylimit_skip'] = true;
        }
    }

    public function isUserInWhitelist()
    {
        if (!OW::getUser()->isAuthenticated() || OW::getUser()->isAdmin()) {
            return true;
        }
        return false;
    }

    public function isUrlInWhitelist()
    {
        $requestUri = OW::getRequest()->getRequestUri();
        if (in_array($requestUri, ['sign-out' ,'mobile-version','desktop-version'])||
            strpos($requestUri, 'activitylimit') > -1) {
            return true;
        }

        return false;
    }

    public function onApplicationInit(OW_Event $event)
    {
        if ($this->isUserInWhitelist()) {
            $GLOBALS['iisactivitylimit_skip'] = true;
            return;
        }

        if ($this->isUrlInWhitelist()) {
            $GLOBALS['iisactivitylimit_skip'] = true;
            return;
        }

        $GLOBALS['iisactivitylimit_skip'] = false;
        if(IISACTIVITYLIMIT_BOL_Service::getInstance()->isLocked()){
            OW::getEventManager()->trigger(new OW_Event('iisactivitylimit.on_before_user_redirect_to_block_page'));
            if (OW::getRequest()->isAjax()){
                exit(json_encode(['result'=>'error', 'message'=>'too much requests!']));
            }
            OW::getApplication()->redirect(OW::getRouter()->urlForRoute('iisactivitylimit.blocked'));
        }
    }
}