<?php
/**
 * iisactivitylimit
 */

/**
 * @author Issa Annamoradnejad <i.moradnejad@gmail.com>
 * @package ow_plugins.iisactivitylimit
 * @since 1.0
 */
class IISACTIVITYLIMIT_CTRL_Admin extends ADMIN_CTRL_Abstract
{

    public function index()
    {
        $this->setPageTitle(OW::getLanguage()->text('iisactivitylimit', 'admin_title'));
        $this->setPageHeading(OW::getLanguage()->text('iisactivitylimit', 'admin_title'));

        $config = OW::getConfig();
        $lang = OW::getLanguage();

        $form = new Form('settings');
        $this->addForm($form);

        $field1 = new TextField('max_db_requests');
        $field1->setRequired(true);
        $validator = new IntValidator();
        $validator->setMinValue(5);
        $validator->setMaxValue(10000000);
        $field1->addValidator($validator);
        $field1->setLabel($lang->text('iisactivitylimit','max_db_requests'));
        $field1->setValue($config->getValue('iisactivitylimit', 'max_db_requests'));
        $form->addElement($field1);

        $field1 = new TextField('minutes_to_reset');
        $field1->setRequired(true);
        $validator = new IntValidator();
        $validator->setMinValue(1);
        $validator->setMaxValue(30*24*60);
        $field1->addValidator($validator);
        $field1->setLabel($lang->text('iisactivitylimit','minutes_to_reset'));
        $field1->setValue($config->getValue('iisactivitylimit', 'minutes_to_reset'));
        $form->addElement($field1);

        $field1 = new TextField('blocking_minutes');
        $field1->setRequired(true);
        $validator = new IntValidator();
        $validator->setMinValue(1);
        $validator->setMaxValue(30*24*60);
        $field1->addValidator($validator);
        $field1->setLabel($lang->text('iisactivitylimit','blocking_minutes'));
        $field1->setValue($config->getValue('iisactivitylimit', 'blocking_minutes'));
        $form->addElement($field1);

        $submit = new Submit('save');
        $submit->setValue(OW::getLanguage()->text('iisactivitylimit', 'form_submit'));
        $form->addElement($submit);

        if (OW::getRequest()->isPost()) {
            if ($form->isValid($_POST)) {
                OW::getConfig()->saveConfig('iisactivitylimit', 'max_db_requests', intval($_POST['max_db_requests']));
                OW::getConfig()->saveConfig('iisactivitylimit', 'minutes_to_reset', floatval($_POST['minutes_to_reset']));
                OW::getConfig()->saveConfig('iisactivitylimit', 'blocking_minutes', floatval($_POST['blocking_minutes']));
                OW::getFeedback()->info(OW::getLanguage()->text('iisactivitylimit', 'save_successful_message'));
            }
        }
    }
}