<?php
/**
 * Search component class.
 *
 * @author Yaser Alimardany <yaser.alimardany@gmail.com>
 * @package ow_plugins.iisadvancesearch.classes
 * @since 1.0
 */
class IISADVANCESEARCH_CMP_Search extends OW_Component
{
    /**
     * Constructor.
     */
    public function __construct()
    {
        $isGuestAllowed = (boolean)OW::getConfig()->getValue('iisadvancesearch','show_search_to_guest');
        if(!OW::getUser()->isAuthenticated() && !$isGuestAllowed) {
            exit();
        }
        parent::__construct();
        $resultData = array();
        $event = OW::getEventManager()->trigger(new OW_Event('iisadvancesearch.on_collect_search_items',
            array('q' => 'collecting plugin names', 'maxCount' => 10, 'do_query' => false), $resultData));
        $resultData = $event->getData();

        $pluginNames[] =OW_Language::getInstance()->text('iisadvancesearch','all_sections');
        foreach($resultData as $key => $value){
            $tmpFieldKey = 'search_allowed_'.$key;
            if(OW::getConfig()->configExists('iisadvancesearch',$tmpFieldKey)){
                $isAllowed = OW::getConfig()->getValue('iisadvancesearch',$tmpFieldKey);
                if($isAllowed){
                    $pluginNames[] = $value["label"];
                }
            }
            else
                $pluginNames [] = $value["label"];
        }
        $this->assign('pluginNames' ,$pluginNames);

        $searchActionUrl = OW::getRouter()->urlForRoute('iisadvancesearch.search');
        if (strpos($searchActionUrl, 'INVALID_URI') !== false) {
            $this->assign('invalidUrl', true);
        }

        if(OW::getConfig()->configExists('iisadvancesearch','show_entity_author')){
            $isAllowedSowAuthor = OW::getConfig()->getValue('iisadvancesearch','show_entity_author');
            if(!$isAllowedSowAuthor){
                OW::getDocument()->addStyleDeclaration('.result_search_item a.label {display: none;}');
            }
        }

        $this->assign('searchActionUrl', $searchActionUrl);
    }
}