<?php
/**
 * @author Milad Heshmati <milad.heshmati@gmail.com>
 * @package ow_plugins.iisaudio
 * @since 1.0
 */

class IISAUDIO_CTRL_Admin extends ADMIN_CTRL_Abstract
{
    /***
     * IISAUDIO_CTRL_Admin constructor.
     */
    public function __construct()
    {
        parent::__construct();

        if ( OW::getRequest()->isAjax() )
        {
            return;
        }

        $lang = OW::getLanguage();
        $this->setPageHeading($lang->text('iisaudio', 'admin_settings_title'));
        $this->setPageTitle($lang->text('iisaudio', 'admin_settings_title'));
        $this->setPageHeadingIconClass('ow_ic_gear_wheel');
    }

    /***
     *
     */
    public function settings()
    {


        $AudioForm = new Form('AudioForm');

        $lang = OW::getLanguage();
        $config = OW::getConfig();
        $configs = $config->getValues('iisaudio');

        $dashbordaudio = new CheckboxField('audio_dashbord');
        $dashbordaudio->setValue($configs['audio_dashbord']);
        $AudioForm->addElement($dashbordaudio);

        $profileaudio = new CheckboxField('audio_profile');
        $profileaudio->setValue($configs['audio_profile']);
        $AudioForm->addElement($profileaudio);

        $forumaudio = new CheckboxField('audio_forum');
        $forumaudio->setValue($configs['audio_forum']);
        $AudioForm->addElement($forumaudio);

        $saveSettings = new Submit('saveSettings');
        $saveSettings->setValue($lang->text('iisaudio', 'admin_save_settings'));
        $AudioForm->addElement($saveSettings);

        $this->addForm($AudioForm);

        if ( OW::getRequest()->isPost())
        {
            if ( $AudioForm->isValid($_POST) )
            {
                $config->saveConfig('iisaudio', 'audio_dashbord', $AudioForm->getElement('audio_dashbord')->getValue());
                $config->saveConfig('iisaudio', 'audio_profile', $AudioForm->getElement('audio_profile')->getValue());
                $config->saveConfig('iisaudio', 'audio_forum', $AudioForm->getElement('audio_forum')->getValue());
            }
        }


    }
}
