<?php
/**
 * Copyright (c) 2016, Yaser Alimardany
 * All rights reserved.
 */

/**
 *
 * @author Yaser Alimardany <yaser.alimardany@gmail.com>
 * @package ow_plugins.iischallenge.bol
 * @since 1.0
 */
class IISCHALLENGE_BOL_CategoryDao extends OW_BaseDao
{
    private static $classInstance;

    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    public function getDtoClassName()
    {
        return 'IISCHALLENGE_BOL_Category';
    }
    
    public function getTableName()
    {
        return OW_DB_PREFIX . 'iischallenge_challenge_category';
    }

    /***
     * @return array
     */
    public function getAllCategories(){
        $example = new OW_Example();
        return $this->findListByExample($example);
    }

    public function findByTitle($title){
        $example = new OW_Example();
        $example->andFieldEqual('title',$title);
        return $this->findObjectByExample($example);
    }
}
