<?php
/**
 * Copyright (c) 2016, Yaser Alimardany
 * All rights reserved.
 */

/**
 *
 * @author Yaser Alimardany <yaser.alimardany@gmail.com>
 * @package ow_plugins.iischallenge.bol
 * @since 1.0
 */
class IISCHALLENGE_BOL_UniversalDao extends OW_BaseDao
{
    private static $classInstance;

    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    public function getDtoClassName()
    {
        return 'IISCHALLENGE_BOL_Universal';
    }
    
    public function getTableName()
    {
        return OW_DB_PREFIX . 'iischallenge_challenge_universal';
    }

    public function getUniversalChallengesByUserId($userId){
        $example = new OW_Example();
        $example->andFieldEqual('userId', $userId);
        return $this->findListByExample($example);
    }

    /***
     * @param $challengeId
     * @return IISCHALLENGE_BOL_Universal
     */
    public function findByChallengeId($challengeId){
        $example = new OW_Example();
        $example->andFieldEqual('challengeId', $challengeId);
        return $this->findObjectByExample($example);
    }

    public function getUniversalChallenges(){
        $example = new OW_Example();
        $example->setOrder('`startTime` ASC');
        return $this->findListByExample($example);
    }
}
