<?php
/**
 * Copyright (c) 2016, Yaser Alimardany
 * All rights reserved.
 */

/**
 *
 * @author Yaser Alimardany <yaser.alimardany@gmail.com>
 * @package ow_plugins.iischallenge.bol
 * @since 1.0
 */
class IISCHALLENGE_BOL_UserAnswerDao extends OW_BaseDao
{
    private static $classInstance;

    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    public function getDtoClassName()
    {
        return 'IISCHALLENGE_BOL_UserAnswer';
    }
    
    public function getTableName()
    {
        return OW_DB_PREFIX . 'iischallenge_challenge_user_answer';
    }

    public function findUserAnswer($questionId, $userId, $challengeId){
        $example = new OW_Example();
        $example->andFieldEqual('questionId' , $questionId);
        $example->andFieldEqual('userId' , $userId);
        $example->andFieldEqual('challengeId' , $challengeId);
        return $this->findObjectByExample($example);
    }

    public function addUserAnswer($questionId, $userId, $challengeId, $answerId){
        $answer = new IISCHALLENGE_BOL_UserAnswer();
        $answer->questionId = $questionId;
        $answer->userId = $userId;
        $answer->challengeId = $challengeId;
        $answer->answerId = $answerId;
        $this->save($answer);
        return $answer;
    }

    public function findUsers($challengeId){
        $query = " SELECT DISTINCT userId FROM " . $this->getTableName() . " where challengeId = :challengeId";
        $param = array(":challengeId" => $challengeId);
        return $this->dbo->queryForList($query, $param);
    }
}
