<?php
/**
 * Copyright (c) 2016, Yaser Alimardany
 * All rights reserved.
 */

/**
 *
 *
 * @author Yaser Alimardany <yaser.alimardany@gmail.com>
 * @package ow_plugins.iischallenge.bol
 * @since 1.0
 */
class IISCHALLENGE_CLASS_EventHandler
{
    private static $classInstance;

    public static function getInstance()
    {
        if (self::$classInstance === null) {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }


    private function __construct()
    {
    }

    public function init()
    {
        $eventManager = OW::getEventManager();
        $service = IISCHALLENGE_BOL_SolitaryService::getInstance();
        $generalService = IISCHALLENGE_BOL_GeneralService::getInstance();
        $eventManager->bind('admin.add_auth_labels', array($generalService, 'addAuthLabels'));
        $eventManager->bind('notifications.collect_actions', array($service, 'onCollectNotificationActions'));
    }
}