<?php
/**
 * Copyright (c) 2016, Mohammad Aghaabbasloo
 * All rights reserved.
 */

/**
 *
 *
 * @author Mohammad Aghaabbasloo <a.mohammad85@gmail.com>
 * @package ow_plugins.iiscommentplus.classes
 * @since 1.0
 */
class IISCOMMENTPLUS_MCLASS_EventHandler
{
    private static $classInstance;

    public static function getInstance()
    {
        if (self::$classInstance === null) {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }


    private function __construct()
    {
    }

    public function init()
    {
        $service = IISCOMMENTPLUS_BOL_Service::getInstance();
        $eventManager = OW::getEventManager();
        $eventManager->bind('base_add_comment', array($service, 'iiscommentplus_afterComment_notification'));
        $eventManager->bind('mobile.notifications.on_item_render', array($this, 'onNotificationRender'));
        OW::getEventManager()->bind('base_delete_comment', array($service, 'deleteComment'));
    }

    public function onNotificationRender( OW_Event $e )
    {
        $params = $e->getParams();

        if ( $params['pluginKey'] != 'base'|| ($params['entityType'] != 'base_profile_wall'))
        {
            return;
        }

        $data = $params['data'];

        if ( !isset($data['avatar']['urlInfo']['vars']['username']) )
        {
            return;
        }

        $userService = BOL_UserService::getInstance();
        $user = $userService->findByUsername($data['avatar']['urlInfo']['vars']['username']);
        if ( !$user )
        {
            return;
        }
        $e->setData($data);
    }

}