<?php
/**
 * @author Mohammad Reza Heidarian
 * Date: 8/25/2017
 * Time: 10:29 AM
 */

$languageService = Updater::getLanguageService();

$languages = $languageService->getLanguages();
$langEnId = null;
$langFaId = null;
foreach ($languages as $lang) {
    if ($lang->tag == 'fa-IR') {
        $langFaId = $lang->id;
    }
    if ($lang->tag == 'en') {
        $langEnId = $lang->id;
    }
}

if ($langFaId != null) {
    $languageService->addOrUpdateValue($langFaId, 'iisevaluation', 'degree_header', 'رده‌بندی فعلی: ');
    $languageService->addOrUpdateValue($langFaId, 'iisevaluation', 'results_header', 'نتایج ارزیابی');
    $languageService->addOrUpdateValue($langFaId, 'iisevaluation', 'requirement_suggest', 'ارزیابی موارد پیشنهادی به تفکیک حوزه‌ها');
    $languageService->addOrUpdateValue($langFaId, 'iisevaluation', 'requirement_normal', 'ارزیابی الزامات عادی به تفکیک حوزه‌ها');
    $languageService->addOrUpdateValue($langFaId, 'iisevaluation', 'requirement_important', 'ارزیابی الزامات مهم به تفکیک حوزه‌ها');
    $languageService->addOrUpdateValue($langFaId, 'iisevaluation', 'requirement_fundamental', 'ارزیابی الزامات اساسی به تفکیک حوزه‌ها');
    $languageService->addOrUpdateValue($langFaId, 'iisevaluation', 'user_value', 'امتیاز کسب شده');
    $languageService->addOrUpdateValue($langFaId, 'iisevaluation', 'remaining_value', 'امتیاز باقی‌مانده');
    $languageService->addOrUpdateValue($langFaId, 'iisevaluation', 'total_value', 'حداکثر امتیاز');
    $languageService->addOrUpdateValue($langFaId, 'iisevaluation', 'questions_without_values', 'برای این سوال، پاسخی ایجاد نشده است.');
    $languageService->addOrUpdateValue($langFaId, 'iisevaluation', 'category_questions_header', 'فهرست سوالات');
    $languageService->addOrUpdateValue($langFaId, 'iisevaluation', 'admin_evaluation_settings_heading', 'تنظیمات افزونه ارزیابی');
    $languageService->addOrUpdateValue($langFaId, 'iisevaluation', 'delete_item_warning', 'آیا از حذف این مورد اطمینان دارید؟');
    $languageService->addOrUpdateValue($langFaId, 'iisevaluation', 'active_item_warning', 'آیا از فعال‌سازی این مورد اطمینان دارید؟');
    $languageService->addOrUpdateValue($langFaId, 'iisevaluation', 'lock_item_warning', 'آیا از قفل‌گذاری روی این مورد اطمینان دارید؟');
}
if ($langEnId != null) {
    $languageService->addOrUpdateValue($langEnId, 'iisevaluation', 'degree_header', 'Current level:');
    $languageService->addOrUpdateValue($langEnId, 'iisevaluation', 'results_header', 'Results of evaluation:');
    $languageService->addOrUpdateValue($langEnId, 'iisevaluation', 'requirement_suggest', 'Assessment of suggested requirements in separate categories');
    $languageService->addOrUpdateValue($langEnId, 'iisevaluation', 'requirement_normal', 'Assessment of normal requirements in separate categories');
    $languageService->addOrUpdateValue($langEnId, 'iisevaluation', 'requirement_important', 'Assessment of important requirements in separate categories');
    $languageService->addOrUpdateValue($langEnId, 'iisevaluation', 'requirement_fundamental', 'Assessment of fundamental requirements in separate categories');
    $languageService->addOrUpdateValue($langEnId, 'iisevaluation', 'user_value', 'Earned point');
    $languageService->addOrUpdateValue($langEnId, 'iisevaluation', 'remaining_value', 'Remaining point');
    $languageService->addOrUpdateValue($langEnId, 'iisevaluation', 'total_value', 'Maximum point');
    $languageService->addOrUpdateValue($langEnId, 'iisevaluation', 'questions_without_values', 'This question has not any values');
    $languageService->addOrUpdateValue($langEnId, 'iisevaluation', 'category_questions_header', 'Questions');
    $languageService->addOrUpdateValue($langEnId, 'iisevaluation', 'admin_evaluation_settings_heading', 'Evaluation plugin setting');
    $languageService->addOrUpdateValue($langEnId, 'iisevaluation', 'delete_item_warning', 'Are you sure to delete this item?');
    $languageService->addOrUpdateValue($langEnId, 'iisevaluation', 'active_item_warning', 'Are you sure to active this item?');
    $languageService->addOrUpdateValue($langEnId, 'iisevaluation', 'lock_item_warning', 'Are you sure to lock this item?');
}