<?php
/**
 * @author Seyed Ismail Mirvakili
 * Date: 8/27/2017
 * Time: 9:15 AM
 */
class IISFARAPAYAMAK_BOL_Service
{
    private static $classInstance;

    public static function getInstance()
    {
        if (self::$classInstance === null) {
            self::$classInstance = new self();
        }
        return self::$classInstance;
    }

    public function __construct()
    {
    }

    public function getSoapUrl()
    {
        if (!OW_Config::getInstance()->configExists('iisfarapayamak', 'provider_soap_url'))
            return null;
        return OW_Config::getInstance()->getValue('iisfarapayamak', 'provider_soap_url');
    }

    public function getRestUrls()
    {
        if (!OW_Config::getInstance()->configExists('iisfarapayamak', 'provider_rest_urls'))
            return null;
        return json_decode(OW_Config::getInstance()->getValue('iisfarapayamak', 'provider_rest_urls'),true);
    }

    public function getPanelUsername()
    {
        if (!OW_Config::getInstance()->configExists('iisfarapayamak', 'panel_username'))
            return null;
        return OW_Config::getInstance()->getValue('iisfarapayamak', 'panel_username');
    }

    public function getPanelPassword()
    {
        if (!OW_Config::getInstance()->configExists('iisfarapayamak', 'panel_password'))
            return null;
        return OW_Config::getInstance()->getValue('iisfarapayamak', 'panel_password');
    }

    public function getPanelNumber()
    {
        if (!OW_Config::getInstance()->configExists('iisfarapayamak', 'panel_number'))
            return null;
        return OW_Config::getInstance()->getValue('iisfarapayamak', 'panel_number');
    }

    public function sendSMS(OW_Event $event)
    {
        $params = $event->getParams();
        if (!isset($params['mobile']))
            return null;
        if (!isset($params['text']))
            return null;
        $result = $this->getSMSProvider()->sendSMS(
            $this->getPanelUsername(),
            $this->getPanelPassword(),
            $this->getPanelNumber(),
            $params['mobile'],
            $params['text']
        );
        $this->addTrack($params['mobile'],$params['text'],$result['recId'],time());
        return array('result' => $result['result']);
    }

    public function getCredit()
    {
        $result = $this->getSMSProvider()->getCredit(
            $this->getPanelUsername(),
            $this->getPanelPassword()
        );
        return array('credit' => (int)$result);
    }

    public function SMSProviderSettingIsComplete(OW_Event $event)
    {
        $result = $this->getSMSProvider()->checkSettingCompletion();
        $event->setData(array('is_complete' => $result));
    }

    /**
     * @return IISFARAPAYAMAK_CLASS_Provider
     */
    public function getSMSProvider()
    {
        $config = OW_Config::getInstance();
        $value = $config->getValue('iisfarapayamak', 'provider');
        if (isset($value))
            switch (strtolower($value)) {
                case 'rest':
                    return IISFARAPAYAMAK_CLASS_FarapayamakRest::getInstance();
                case 'soap':
                    return IISFARAPAYAMAK_CLASS_FarapayamakSoap::getInstance();
            }
        return IISFARAPAYAMAK_CLASS_FarapayamakNull::getInstance();
    }

    public function addTrack($mobile,$message,$smsId,$time){
        $track = new IISFARAPAYAMAK_BOL_Track();
        $track->mobile = $mobile;
        $track->message = $message;
        $track->time = $time;
        $track->smsId = $smsId;
        IISFARAPAYAMAK_BOL_TrackDao::getInstance()->save($track);
    }

    public function checkSMSStatus($smsId){
        $provider = $this->getSMSProvider();
        $result = $provider->checkStatus(
            $this->getPanelUsername(),
            $this->getPanelPassword(),
            $smsId
        );
        return $result;
    }

    public function getStatusString($status){
        $language = OW::getLanguage();
        switch ($status){
            case 0:
                return $language->text('iisfarapayamak','status_0');
            case 1:
                return $language->text('iisfarapayamak','status_1');
            case 2:
                return $language->text('iisfarapayamak','status_2');
            case 3:
                return $language->text('iisfarapayamak','status_3');
            case 5:
                return $language->text('iisfarapayamak','status_5');
            case 8:
                return $language->text('iisfarapayamak','status_8');
            case 16:
                return $language->text('iisfarapayamak','status_16');
            case 35:
                return $language->text('iisfarapayamak','status_35');
            case 100:
                return $language->text('iisfarapayamak','status_100');
            case 200:
                return $language->text('iisfarapayamak','status_200');
            case 300:
                return $language->text('iisfarapayamak','status_300');
            case 400:
                return $language->text('iisfarapayamak','status_400');
            case 500:
                return $language->text('iisfarapayamak','status_500');
            default:
                return $language->text('iisfarapayamak','status_other');
        }
    }
}
