<?php
/**
 * iisforumplus admin action controller
 *
 */
class IISFORUMPLUS_CTRL_Admin extends ADMIN_CTRL_Abstract
{
    /**
     * @param array $params
     */
    public function index(array $params = array())
    {
        $this->setPageHeading(OW::getLanguage()->text('iisforumplus', 'admin_settings_heading'));
        $this->setPageTitle(OW::getLanguage()->text('iisforumplus', 'admin_settings_heading'));
        $this->setPageHeadingIconClass('ow_ic_gear_wheel');
        $config =  OW::getConfig();
        $language = OW::getLanguage();

        $form = new Form('form');

        $field = new CheckboxField('mobile_forum_group_visibile');
        $field->setLabel($language->text('iisforumplus', 'mobile_forum_group_visibile_label'));
        $form->addElement($field);

        $subscribeGroupUsersCheckbox = new CheckboxField('subscribe_group_users_to_topic_checkbox');
        $subscribeGroupUsersCheckbox->setLabel($language->text('iisforumplus', 'subscribe_group_users_to_topic_checkbox_label'));
        $form->addElement($subscribeGroupUsersCheckbox);

        $submit = new Submit('save');
        $form->addElement($submit);
        $this->addForm($form);

        $headerTextArea = new Textarea('headerForumGroupWidgetHtml');
        $headerTextArea->setLabel(OW::getLanguage()->text('iisforumplus', 'header_html_forum_group_widget'));
        //$commentTextArea->setValue($configs['HeaderForumGroupWidgetHtml']);
        $form->addElement($headerTextArea);
        if ( OW::getRequest()->isPost() && $form->isValid($_POST) )
        {
            $data = $form->getValues();
            if ( $config->configExists('iisforumplus', 'mobile_forum_group_visibile') )
            {
                $config->saveConfig('iisforumplus', 'mobile_forum_group_visibile', $data['mobile_forum_group_visibile']);
            }
            if ($config->configExists('iisforumplus', 'subscribe_group_users_to_topic'))
            {
                $config->saveConfig('iisforumplus', 'subscribe_group_users_to_topic', $data['subscribe_group_users_to_topic_checkbox']);
            }
            $config->saveConfig('iisforumplus', 'headerForumGroupWidgetHtml', $data['headerForumGroupWidgetHtml']);

            OW::getFeedback()->info(OW::getLanguage()->text('iisforumplus', 'modified_successfully'));
            $this->redirect();
        }
        if($config->configExists('iisforumplus', 'mobile_forum_group_visibile'))
        {
            $field->setValue($config->getValue('iisforumplus', 'mobile_forum_group_visibile'));
        }
        if ( $config->configExists('iisforumplus', 'headerForumGroupWidgetHtml') )
        {
            $headerTextArea->setValue($config->getValue('iisforumplus', 'headerForumGroupWidgetHtml'));
        }
        if ($config->configExists('iisforumplus', 'subscribe_group_users_to_topic'))
        {
            $subscribeGroupUsersCheckbox->setValue($config->getValue('iisforumplus', 'subscribe_group_users_to_topic'));
        }
    }

}