<?php
/**
 * Class FORUM_CTRL_Topic
 */
class IISFORUMPLUS_CTRL_TopicGroup extends OW_ActionController
{
    private $iisForumPlusService;

    /**
     * Class constructor
     */
    public function __construct()
    {
        parent::__construct();

        $this->iisForumPlusService = IISFORUMPLUS_BOL_Service::getInstance();

    }


    public function addGroupForumTopicToWidget( array $params )
    {
        if(!isset($params['groupId']))
        {
            throw new Redirect404Exception();
        }
        $code = $_GET['code'];
        if(!isset($code)){
            throw new Redirect404Exception();
        }
        OW::getEventManager()->trigger(new OW_Event('iissecurityessentials.on.check.request.manager',
            array('senderId' => OW::getUser()->getId(), 'code'=>$code,'activityType'=>'add_group_topic_widget')));
        $groupId = $params['groupId'];
        $config = OW::getConfig();
        if(!$config->configExists('iisforumplus','selected_groups_forums'))
        {
            $selectedGroupIds = array($groupId);
            $config->addConfig('iisforumplus', 'selected_groups_forums',   json_encode($selectedGroupIds));
        }else{
            $selectedGroupIds  = json_decode($config->getValue('iisforumplus','selected_groups_forums'),true);
            if ( !in_array($groupId,$selectedGroupIds) ){
                array_push($selectedGroupIds,$groupId);
                $config->saveConfig('iisforumplus', 'selected_groups_forums',   json_encode($selectedGroupIds));
            }
        }
        OW::getFeedback()->info(OW::getLanguage()->text('iisforumplus', 'add_success_msg'));
        $this->redirect(OW::getRouter()->urlForRoute('groups-view', array('groupId' => $groupId)));
    }

    public function removeGroupForumTopicToWidget( array $params )
    {
        if(!isset($params['groupId']))
        {
            throw new Redirect404Exception();
        }
        $code = $_GET['code'];
        if(!isset($code)){
            throw new Redirect404Exception();
        }
        OW::getEventManager()->trigger(new OW_Event('iissecurityessentials.on.check.request.manager',
            array('senderId' => OW::getUser()->getId(), 'code'=>$code,'activityType'=>'remove_group_topic_widget')));
        $groupId = $params['groupId'];
        $config = OW::getConfig();
        if(!$config->configExists('iisforumplus','selected_groups_forums'))
        {

        }else{
            $selectedGroupIds  = json_decode($config->getValue('iisforumplus','selected_groups_forums'),true);
            if (($key = array_search($groupId, $selectedGroupIds)) !== false) {
                unset($selectedGroupIds[$key]);
                $config->saveConfig('iisforumplus', 'selected_groups_forums',   json_encode($selectedGroupIds));
            }
        }
        OW::getFeedback()->info(OW::getLanguage()->text('iisforumplus', 'remove_success_msg'));
        $this->redirect(OW::getRouter()->urlForRoute('groups-view', array('groupId' => $groupId)));
    }
}
