<?php
/**
 * @author Yaser Alimardany <yaser.alimardany@gmail.com>
 * @author Issa Annamoradnejad <i.moradnejad@gmail.com>
 * @package ow_plugins.iisftpmanager.bol
 * @since 1.0
 */

class IISFTPMANAGER_BOL_Service
{
    private static $classInstance;

    public static function getInstance()
    {
        if (self::$classInstance === null) {
            self::$classInstance = new self();
        }
        return self::$classInstance;
    }

    public function __construct(){
    }

    public function isFtpNotExist(OW_Event $event)
    {
        $config = OW::getConfig();
        $ftpAttrsIsNotExist = false;
        if($config->getValue("iisftpmanager", "host") == "" ||
            $config->getValue("iisftpmanager", "username") == "" ||
            $config->getValue("iisftpmanager", "password") == "" ||
            $config->getValue("iisftpmanager", "port") == ""
        ){
            $ftpAttrsIsNotExist = true;
        }
        $event->setData(array("ftpAttrsIsNotExist" => $ftpAttrsIsNotExist));
    }

    public function getFtpAttrs(OW_Event $event)
    {
        $config = OW::getConfig();
        $host = $config->getValue("iisftpmanager", "host");
        $username = $config->getValue("iisftpmanager", "username");
        $password = $config->getValue("iisftpmanager", "password");
        $port = $config->getValue("iisftpmanager", "port");
        $event->setData(array("getFtpAttrs" => array("host" => $host, "login" => $username, "password" => $password, "port" => $port)));
    }

    public function saveFtpAttrs(OW_Event $event){
        $ftpAttr = $event->getParams();
        if(isset($ftpAttr['ftpAttrs'])){
            $ftpAttr = $ftpAttr['ftpAttrs'];
            $config = OW::getConfig();
            if(isset($ftpAttr['login'])){
                $config->saveConfig('iisftpmanager', 'username', $ftpAttr['login']);
            }
            if(isset($ftpAttr['host'])){
                $config->saveConfig('iisftpmanager', 'host', $ftpAttr['host']);
            }
            if(isset($ftpAttr['password'])){
                $config->saveConfig('iisftpmanager', 'password', $ftpAttr['password']);
            }
            if(isset($ftpAttr['port'])){
                $config->saveConfig('iisftpmanager', 'port', $ftpAttr['port']);
            }
        }
    }

    public function onBeforeFtp(OW_Event $event){
        OW::getApplication()->redirect(OW::getRouter()->urlForRoute('iisftpmanager_admin_setting'));
    }

    public function onBeforeGetFtpConnection(OW_Event $event){
        if(!OW::getConfig()->getValue('iisftpmanager', 'ftp_enabled')){
            $event->setData(['ftpConnection' => IISFTPMANAGER_CLASS_Ftp::getConnection([])]);
        }
    }
}
