<?php
/**
 * IIS Graph
 */
/**
 * @author Issa Annamoradnejad <i.moradnejad@gmail.com>
 * @package ow_plugins.iisgraph
 * @since 1.0
 */

class IISGRAPH_CMP_AdminGraph extends OW_Component
{

    /**
     * IISGRAPH_CMP_AdminGraph constructor.
     * @param BASE_CLASS_WidgetParameter $params
     * @param $isAdminPage
     */
    public function __construct($params = null, $isAdminPage = true)
    {
        parent::__construct();
        $this->graphCmp($params, $isAdminPage);
    }

    private function graphCmp($params, $isAdminPage = true)
    {
        $service = IISGRAPH_BOL_Service::getInstance();
        if($isAdminPage){
            $this->assign('sections', $service->getAdminSections(1));
            $this->assign('subsections', $service->getAdminSubSections(1,2));
        }else{
            $this->assign('sections', $service->getGraphSections(1));
            $this->assign('subsections', $service->getGraphSubSections(1,2));
        }

        $selectedGroupId = $service->getSelectedGroupId();
        if (isset($selectedGroupId))
            $this->assign("lastCalculationDate", UTIL_DateTime::formatSimpleDate(
                $service->getLastGraphCalculatedMetricsByGroupId($selectedGroupId)->time));

        $graphPlugin = OW::getPluginManager()->getPlugin('iisgraph');
        OW::getDocument()->addScript($graphPlugin->getStaticJsUrl().'vis.min.js');
        OW::getDocument()->addScript($graphPlugin->getStaticJsUrl().'graph.js');
        OW::getDocument()->addStyleSheet($graphPlugin->getStaticCssUrl().'vis.min.css');
        OW::getDocument()->addStyleSheet($graphPlugin->getStaticCssUrl().'graph.css');
        $clusterByQuestion = OW::getConfig()->getValue('iisgraph', 'question');

        $js = "var nodes = [";
        $numberOfUsers = BOL_UserService::getInstance()->count(true);
        $users = BOL_UserService::getInstance()->findList(0, $numberOfUsers, true);

        $userIdList = array();
        foreach ($users as $user) {
            $userIdList[] = $user->id;
        }

        $questionClusterValue = BOL_QuestionService::getInstance()->getQuestionData($userIdList, array($clusterByQuestion));

        foreach ($users as $key => $user) {
            $groupValue = -1;
            if(isset($questionClusterValue[$user->id][$clusterByQuestion])){
                $groupValue = $questionClusterValue[$user->id][$clusterByQuestion];
            }
            $js = $js . "{id: ".$user->id.", label: '".$user->username."', title: '".$user->email."', value: 1, group: ".$groupValue."},";
        }
        $js = substr($js, 0, strlen($js) - 1);
        $js .= "];";

        $js .= "var edges = [";
        $edgeList = $service->getAllRelationship();
        foreach ($edgeList as $friendship){
            $js = $js . "{from: ".$friendship['userId'].", to: ".$friendship['feedId']."},";
        }
        $js = substr($js, 0, strlen($js) - 1);
        $js .= "];";
        $js .= "redrawAll(nodes, edges);";
        OW::getDocument()->addOnloadScript($js);


        //cluster
        $serverForm = new Form('clusterForm');

        $config = OW::getConfig();
        $questionField = new Selectbox('question');
        $questionField->setLabel(OW::getLanguage()->text('iisgraph', 'cluster_by_question'));
        $questionField->addOptions($service->getAllQuestionsProfile());
        $questionField->setValue($config->getValue('iisgraph', 'question'));
        $serverForm->addElement($questionField);

        $submitField = new Submit('submit');
        $serverForm->addElement($submitField);
        $this->addForm($serverForm);

        if (OW::getRequest()->isPost() && $serverForm->isValid($_POST)) {
            $data = $serverForm->getValues();
            $config->saveConfig('iisgraph', 'question', $data['question']);
            OW::getFeedback()->info(OW::getLanguage()->text('iisgraph', 'modified_successfully'));
            $this->redirect();
        }
    }
}