<?php
/**
 * IIS Graph widget
 *
 * @author Yaser Alimardany <yaser.alimardany@gmail.com>
 * @since 1.0
 */
class IISGRAPH_CMP_TopUsersWidget extends BASE_CLASS_Widget
{

    /**
     * IISGRAPH_CMP_TopUsersWidget constructor.
     * @param BASE_CLASS_WidgetParameter $params
     */
    public function __construct( BASE_CLASS_WidgetParameter $params )
    {
        parent::__construct();
        $topUsersCmp = new IISGRAPH_CMP_TopUsers(true, 5, false, 5);
        $this->addComponent('topUsers', $topUsersCmp);
    }

    public static function getStandardSettingValueList()
    {
        return array(
            self::SETTING_SHOW_TITLE => true,
            self::SETTING_WRAP_IN_BOX => true,
            self::SETTING_TITLE => OW_Language::getInstance()->text('iisgraph', 'top_users_widget'),
            self::SETTING_ICON => self::ICON_USER
        );
    }

    public static function getAccess()
    {
        return self::ACCESS_ALL;
    }
}