<?php
/**
 * IIS Graph
 */
/**
 * @author Yaser Alimardany <yaser.alimardany@gmail.com>
 * @author Issa Annamoradnejad <i.moradnejad@gmail.com>
 * @package ow_plugins.iisgraph
 * @since 1.0
 */
class IISGRAPH_CTRL_Admin extends ADMIN_CTRL_Abstract
{
    public function index( array $params = array() )
    {
        $service = IISGRAPH_BOL_Service::getInstance();
        OW::getDocument()->setTitle(OW::getLanguage()->text('iisgraph', 'admin_settings_title'));
        OW::getDocument()->setHeading(OW::getLanguage()->text('iisgraph', 'admin_settings_title'));
        $config = OW::getConfig();

        $calculateForm = new Form('calculateForm');
        $calculateForm->setAction(OW::getRouter()->urlForRoute('iisgraph.calculate'));
        $submitGetCentralityField = new Submit('submit');
        $calculateForm->addElement($submitGetCentralityField);

        $form = new Form('form');
        $form->setAction(OW::getRouter()->urlForRoute('iisgraph.admin'));

        $serverField = new TextField('server');
        $serverField->setLabel(OW::getLanguage()->text('iisgraph', 'server'));
        $serverField->setValue($config->getValue('iisgraph', 'server'));
        $serverField->setRequired();
        $form->addElement($serverField);

        $snapshotField = new Selectbox('group_id');
        $allGraphSnapshots = $service->getLatestRunsByTime();
        $selectedGroupId = -1;
        if(OW::getConfig()->configExists('iisgraph','group_id')){
            $selectedGroupId = OW::getConfig()->getValue('iisgraph','group_id');
        }
        $snapshotField->addOption('-1', OW::getLanguage()->text('iisgraph','last_snapshot'));
        foreach ( $allGraphSnapshots as $oneSnapshot )
        {
            $snapshotField->addOption($oneSnapshot->groupId, UTIL_DateTime::formatSimpleDate($oneSnapshot->time));
        }
        $snapshotField->setValue($selectedGroupId);
        $snapshotField->setRequired();
        $snapshotField->setHasInvitation(false);
        $snapshotField->setLabel(OW::getLanguage()->text('iisgraph', 'label_which_snapshot_result'));
        $form->addElement($snapshotField);

        $cronField = new Selectbox('cron_period');
        $selectedItem = 7*24*60;
        if(OW::getConfig()->configExists('iisgraph','cron_period')){
            $selectedItem = OW::getConfig()->getValue('iisgraph','cron_period');
        }
        $cronField->addOption(-1, OW::getLanguage()->text('iisgraph','disabled'));
        $cronField->addOption(24*60, OW::getLanguage()->text('iisgraph','time_daily'));
        $cronField->addOption(7*24*60, OW::getLanguage()->text('iisgraph','time_weekly'));
        $cronField->addOption(30*7*24*60, OW::getLanguage()->text('iisgraph','time_monthly'));
        $cronField->setValue($selectedItem);
        $cronField->setRequired();
        $cronField->setHasInvitation(false);
        $cronField->setLabel(OW::getLanguage()->text('iisgraph', 'label_cron_period'));
        $form->addElement($cronField);

        $submitField = new Submit('submit');
        $form->addElement($submitField);

        $this->addForm($calculateForm);
        $this->addForm($form);

        if (OW::getRequest()->isPost() && $form->isValid($_POST)) {
            $data = $form->getValues();
            $config->saveConfig('iisgraph', 'server', $data['server']);
            if($data['group_id']==-1){
                $config->deleteConfig('iisgraph', 'group_id');
            }
            else {
                $config->saveConfig('iisgraph', 'group_id', $data['group_id']);
            }
            $config->saveConfig('iisgraph', 'cron_period', $data['cron_period']);

            // clear cache
            @unlink(IISGRAPH_BOL_Service::getTopUsersCacheFilePath());

            OW::getFeedback()->info(OW::getLanguage()->text('iisgraph', 'modified_successfully'));
            $this->redirect();
        }


        $testForm = new Form('test');
        $testForm->setAction(OW::getRouter()->urlForRoute('iisgraph.admin'));
        $submitField = new Submit('submit');
        $testForm->addElement($submitField);
        $this->addForm($testForm);
        if (OW::getRequest()->isPost() && $testForm->isValid($_POST)) {
            $url = $config->getValue('iisgraph', 'server');
            $result = OW::getStorage()->fileGetContent($url);
            if(isset($result) && !empty($result)){
                $json = json_decode($result,true);
                if(isset($json) && isset($json['version'])){
                    OW::getFeedback()->info(OW::getLanguage()->text('iisgraph', 'test_connection_successfully'));
                    $this->redirect();
                }
            }
            OW::getFeedback()->error(OW::getLanguage()->text('iisgraph', 'test_connection_failed'));
            $this->redirect();
        }
    }

    public function graph()
    {
        $graphCmp = new IISGRAPH_CMP_AdminGraph();
        $this->addComponent('graphCmp',$graphCmp);
    }

    public function calculateAllInformation(){
        $service = IISGRAPH_BOL_Service::getInstance();
        $service->calculateAllInformation();
        OW::getFeedback()->info(OW::getLanguage()->text('iisgraph', 'calculate_all_metrics_successfully'));
        $this->redirect(OW::getRouter()->urlForRoute('iisgraph.admin'));
    }
}
