<?php
/**
 * @author Yaser Alimardani <yaser.alimardany@gmail.com>
 * @package ow_plugins.iisgroupsplus
 * @since 1.0
 */
class IISGROUPSPLUS_CMP_PendingInvitation extends BASE_CLASS_Widget
{

    public function __construct( BASE_CLASS_WidgetParameter $params )
    {
        parent::__construct();
        $groupId = null;
        if(isset($params->additionalParamList) && isset($params->additionalParamList['entityId'])){
            $groupId = $params->additionalParamList['entityId'];
        }

        $usersInvitedComponent = new IISGROUPSPLUS_CMP_PendingUsers($groupId);
        $this->addComponent('usersInvitedComponent', $usersInvitedComponent);
    }

    public static function getStandardSettingValueList()
    {
        return array(
            self::SETTING_SHOW_TITLE => true,
            self::SETTING_WRAP_IN_BOX => true,
            self::SETTING_TITLE => OW_Language::getInstance()->text('iisgroupsplus', 'pending_invitation'),
            self::SETTING_ICON => self::ICON_USER
        );
    }

    public static function getAccess()
    {
        return self::ACCESS_MEMBER;
    }
}