/**
 * Copyright (c) 2017, Mohammad Reza Heidarian
 * All rights reserved.
 */

/**
 *
 *
 * @author Mohammad Reza Heidarian
 * @package ow_plugins.iisguidedtour
 * @since 1.0
 */

function iisgt_setUnseenAndReload() {
    iisgt_cookie_setUnseen();
    $.ajax({
            url: iisgt_ajax_unseen_url,
            type: 'post',
            success: function (data) {
                data = JSON.parse(data);
                if (data.result == 'true') {
                    window.location.href = iisgt_home_url;
                }
            },
            error: function () {
                console.log("Data didn't get sent!!");
            }
        });
}

function iisgt_createCookie(name,value,days) {
    var expires = "";
    if (days) {
        var date = new Date();
        date.setTime(date.getTime() + (days*24*60*60*1000));
        expires = "; expires=" + date.toUTCString();
    }
    document.cookie = name + "=" + value + expires + "; path=/";
}

function iisgt_readCookie(name) {
    var nameEQ = name + "=";
    var ca = document.cookie.split(';');
    for(var i=0;i < ca.length;i++) {
        var c = ca[i];
        while (c.charAt(0)==' ') c = c.substring(1,c.length);
        if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
    }
    return null;
}

function iisgt_eraseCookie(name) {
    iisgt_createCookie(name,"",-1);
}

function iisgt_cookie_setSeen() {
    iisgt_createCookie("iisgt_seen", true);
}

function iisgt_cookie_setUnseen() {
    iisgt_eraseCookie("iisgt_seen");
}

function iisgt_cookie_isSeen() {
    var seen = iisgt_readCookie("iisgt_seen");
    if(seen)
        return true;
    else
        return false;
}

