<?php
class IISLIKE_CLASS_EventHandler
{
    /**
     *
     * @var IISLIKE_BOL_Service
     */
    private $service;

    public function __construct()
    {
        $this->service = IISLIKE_BOL_Service::getInstance();
    }

    public function init()
    {
        $service=IISLIKE_BOL_Service::getInstance();
        $eventManager = OW::getEventManager();
        $eventManager->bind(OW_EventManager::ON_BEFORE_DOCUMENT_RENDER, array($this, 'addLikeStaticData'));
        $eventManager->bind('notifications.collect_actions', array($this, 'onCollectNotificationActions'));
        $eventManager->bind('add.newsfeed.comment.like.component', array($service, 'addNewsfeedCommentLikeComponent'));
    }

    public function onCollectNotificationActions( BASE_CLASS_EventCollector $e )
    {
        $sectionLabel = OW::getLanguage()->text('iislike','notification_section_label');
        $e->add(array(
            "section" => 'iislike',
            "action" => 'iislike-comment',
            "description" => OW::getLanguage()->text('iislike','comment_notifications_setting'),
            "selected" => true,
            "sectionLabel" => $sectionLabel,
            "sectionIcon" => 'ow_ic_write'
        ));
    }

    public function addLikeStaticData()
    {
        OW::getDocument()->addScript(OW::getPluginManager()->getPlugin('iislike')->getStaticJsUrl() . 'iislike.js');
    }
}
