<?php
class IISLIKE_CMP_Action extends OW_Component
{
    /**
     * @var array
     */
    private static $data;

    /**
     * @var IISLIKE_BOL_Service
     */
    private $service;

    /**
     * @var string
     */
    private $entityType;

    /**
     * @var int
     */
    private $entityId;

    /**
     * @var array
     */
    private $statData;

    /**
     * @var int 
     */
    private $myVote;

    /**
     * @var string
     */
    private $id;

    /**
     * @var int
     */
    private $ownerId;

    /**
     * @var string
     */
    private $parentClass;

    /**
     * Constructor.
     */
    public function __construct( $entityId, $entityType, $statData, $myVote, $ownerId, $parentClass )
    {
        parent::__construct();
        $this->service = IISLIKE_BOL_Service::getInstance();
        $this->entityId = $entityId;
        $this->entityType = $entityType;
        $this->statData = $statData;
        $this->myVote =false;
        if(isset($myVote->vote))
        {
            $this->myVote=$myVote->vote;
        }
        $this->id = IISSecurityProvider::generateUniqueId('iislike-');
        $this->ownerId = (int) $ownerId;
        $this->parentClass = trim($parentClass);

        if ( self::$data === null )
        {
            self::$data = array(
                "loginMessage" =>OW::getLanguage()->text('iislike','like_login_msg'),
                "ownerMessage" => OW::getLanguage()->text('iislike','like_owner_msg_new'),
                "likedListLabel" => OW::getLanguage()->text('iislike','liked_user_list'),
                "dislikedListLabel" => OW::getLanguage()->text('iislike','disliked_user_list'),
                "totalListLabel" => OW::getLanguage()->text('iislike','total_user_list'),
                "respondUrl" => OW::getRouter()->urlFor("IISLIKE_CTRL_Action", "action"),
                "currentUserId" => OW::getUser()->isAuthenticated() ? OW::getUser()->getId() : -1,
                "currentUri" => urlencode(OW::getRequest()->getRequestUri())
            );

            OW::getDocument()->addOnloadScript("window.IISLIKEData = " . json_encode(self::$data) . ";");
        }
    }

    public function onBeforeRender()
    {
        parent::onBeforeRender();
        $commonUserList = array_merge((empty($this->statData['upUserId']) ? array() : $this->statData['upUserId']), (empty($this->statData['downUserId']) ? array() : $this->statData['downUserId']));

        $dataToAssign = array(
            "cmpId" => $this->id,
            "userVote" => $this->myVote,
            "entityId" => $this->entityId,
            "entityType" => $this->entityType,
            "ownerId" => $this->ownerId,
            "total" => empty($this->statData["sum"]) ? 0 : intval($this->statData["sum"]),
            "count" => empty($this->statData["count"]) ? 0 : intval($this->statData["count"]),
            "up" => empty($this->statData["up"]) ? 0 : intval($this->statData["up"]),
            "down" => empty($this->statData["down"]) ? 0 : intval($this->statData["down"]),
            "ownerBlock" => (OW::getUser()->isAuthenticated() && OW::getUser()->getId() == $this->ownerId),
            "upUserId" => (!empty($this->statData["upUserId"])) ? $this->statData["upUserId"] : array(),
            "downUserId" => (!empty($this->statData["downUserId"])) ? $this->statData["downUserId"] : array(),
            "commonUserId" => (!empty($commonUserList) ) ? $commonUserList : array(),
            "parentClass" => $this->parentClass,
            "currentUserId" => OW::getUser()->isAuthenticated() ? OW::getUser()->getId() : -1
        );

        $this->assign("data", $dataToAssign);
        OW::getDocument()->addOnloadScript("new IISLIKE(" . json_encode($dataToAssign) . ");");
        $mobileEvent = OW::getEventManager()->trigger(new OW_Event(IISEventManager::IS_MOBILE_VERSION,array('check' => true)));
        if(isset($mobileEvent->getData()['isMobileVersion'])&& $mobileEvent->getData()['isMobileVersion']==true) {
            $this->assign('isMobile',true);
        }
    }
}
