<?php
class IISLIKE_CTRL_Action extends OW_ActionController
{
    /**
     * @var BOL_VoteService
     */
    private $voteService;

    /**
     * Constructor.
     */
    public function __construct()
    {
        if ( !OW::getRequest()->isAjax() )
        {
            throw new Redirect404Exception();
        }

        $this->voteService = BOL_VoteService::getInstance();
    }

    public function action()
    {
        $validEntityType=array('user-status','groups-status','blog-post','news-entry');

        if ( !OW::getUser()->isAuthenticated() )
        {
            exit(json_encode(array('result' => false, 'message' => OW::getLanguage()->text('iislike', 'like_login_msg'))));
        }

        if ( !isset($_POST['entityId']) || !isset($_POST['entityType']) || !isset($_POST['ownerId']) || !isset($_POST['total']) || !isset($_POST['userVote']) || !isset($_POST['uri']) )
        {
            exit(json_encode(array('result' => false, 'message' => 'Backend error!')));
        }
        $entityId = (int) $_POST['entityId'];
        $entityType = trim($_POST['entityType']);
        $userVote = (int) $_POST['userVote'];
        $uri = urldecode(trim($_POST['uri']));

        $voteDto = $this->voteService->findUserVote($entityId, $entityType, OW::getUser()->getId());

        if ( $userVote == 0 )
        {
            if ( $voteDto !== null )
            {
                $this->voteService->delete($voteDto);
                OW::getEventManager()->call('notifications.remove', array(
                    'entityType' => $entityType,
                    'entityId' => $entityId
                ));
            }
        }
        else {
            if ($voteDto === null) {
                $voteDto = new BOL_Vote();
                $voteDto->setUserId(OW::getUser()->getId());
                $voteDto->setEntityType($entityType);
                $voteDto->setEntityId($entityId);
            }

            $voteDto->setVote($userVote);
            $voteDto->setTimeStamp(time());
            $this->voteService->saveVote($voteDto);
            $action = "iislike-comment";
            $comment = BOL_CommentService::getInstance()->findComment($entityId);
            $ownerId=$comment->userId;
            $commentEntity = BOL_CommentService::getInstance()->findCommentEntityById($comment->commentEntityId);
            $entityData = explode('iislike-', $entityType);
            $originalEntityType = $entityData[1];
            if(!in_array($originalEntityType,$validEntityType))
            {
                exit(json_encode(array('result' => false, 'message' => 'Error!')));
            }
            if(OW::getUser()->getId()==$comment->userId)
            {
                exit(json_encode(array("result" => true, "message" => "Success!")));
            }
            switch ($originalEntityType)
            {
                case 'user-status':
                case 'groups-status':
                    if (IISSecurityProvider::checkPluginActive('newsfeed', true)) {
                        $newsfeedAction = NEWSFEED_BOL_Service::getInstance()->findAction($originalEntityType, $commentEntity->entityId);
                        OW::getEventManager()->trigger(new OW_Event(IISEventManager::ON_BEFORE_FEED_ITEM_RENDERER, array('actionId' => $newsfeedAction->getId(), 'feedId' => null, 'throwEx' => false)));
                        $commentUrl = OW::getRouter()->urlForRoute('newsfeed_view_item', array('actionId' => $newsfeedAction->getId(), 'feedId' => null));
                    }
                    break;
                case 'blog-post':
                    if (IISSecurityProvider::checkPluginActive('blogs', true)) {
                        $post = PostService::getInstance()->findById($commentEntity->entityId);

                        if ($post === null) {
                            exit(json_encode(array("result" => false,"error"=>"404 Exception", "message" => "Error!")));
                        }
                        if ($post->isDraft() && $post->authorId != OW::getUser()->getId()) {
                            exit(json_encode(array("result" => false,"error"=>"404 Exception", "message" => "Error!")));
                        }
                        if ( !OW::getUser()->isAuthorized('blogs', 'view') )
                        {
                            exit(json_encode(array("result" => false,"error"=>"404 Exception", "message" => "Error!")));
                        }

                        if ( ( OW::getUser()->isAuthenticated() && OW::getUser()->getId() != $post->getAuthorId() ) && !OW::getUser()->isAuthorized('blogs', 'view') )
                        {
                            exit(json_encode(array("result" => false,"error"=>"404 Exception", "message" => "Error!")));
                        }

                        /* Check privacy permissions */
                        if ( $post->authorId != OW::getUser()->getId() && !OW::getUser()->isAuthorized('blogs') )
                        {
                            $eventParams = array(
                                'action' => 'blogs_view_blog_posts',
                                'ownerId' => $post->authorId,
                                'viewerId' => OW::getUser()->getId()
                            );

                            OW::getEventManager()->getInstance()->call('privacy_check_permission', $eventParams);
                        }
                        /* */
                        $commentUrl = $commentUrl = OW::getRouter()->urlForRoute('post', array('id' => $commentEntity->entityId));
                    }
                    break;
                case 'news-entry':
                    if (IISSecurityProvider::checkPluginActive('iisnews', true)) {
                        $entry = EntryService::getInstance()->findById($commentEntity->entityId);
                        if ( $entry === null )
                        {
                            exit(json_encode(array("result" => false,"error"=>"404 Exception", "message" => "Error!")));
                        }
                        if ($entry->isDraft() && $entry->authorId != OW::getUser()->getId())
                        {
                            exit(json_encode(array("result" => false,"error"=>"404 Exception", "message" => "Error!")));
                        }
                        if ( !OW::getUser()->isAuthorized('iisnews', 'view')  && !OW::getUser()->isAdmin())
                        {
                            exit(json_encode(array("result" => false,"error"=>"404 Exception", "message" => "Error!")));
                        }
                        if ( ( OW::getUser()->isAuthenticated() && OW::getUser()->getId() != $entry->getAuthorId() ) && !OW::getUser()->isAuthorized('iisnews', 'view') )
                        {
                            exit(json_encode(array("result" => false,"error"=>"404 Exception", "message" => "Error!")));
                        }
                        $commentUrl = $commentUrl = OW::getRouter()->urlForRoute('entry', array('id' => $commentEntity->entityId));
                    }
                    break;
                default:
                    break;
            }
            $langKey = $userVote > 0 ? "notification_comment_like_string" : "notification_comment_dislike_string";
            $avatars = BOL_AvatarService::getInstance()->getDataForUserAvatars(array($voteDto->getUserId()));
            $event = new OW_Event("notifications.add", array(
                "pluginKey" => 'iislike',
                "entityType" => $entityType,
                "entityId" => $entityId,
                "action" => $action,
                "userId" => $ownerId,
                "time" => time()
            ), array(
                "avatar" => $avatars[$voteDto->getUserId()],
                "string" => array(
                    "key" => "iislike+" . $langKey,
                    "vars" => array(
                        "displayName" => BOL_UserService::getInstance()->getDisplayName($voteDto->getUserId()),
                        "userUrl" => BOL_UserService::getInstance()->getUserUrl($voteDto->getUserId()),
                        "commentUrl" => isset($commentUrl) ? $commentUrl : OW_URL_HOME . $uri
                    )
                ),
                "url" => isset($commentUrl) ? $commentUrl : OW_URL_HOME . $uri
            ));

            OW::getEventManager()->trigger($event);
        }
        exit(json_encode(array("result" => true, "message" => "Success!")));
    }
}
