<?php

/**
 * @author Issa Annamoradnejad <i.moradnejad@gmail.com>
 */
class IISMAGFA_BOL_Service
{
    private static $classInstance;
    private $wsObj;
    public static function getInstance()
    {
        if (self::$classInstance === null) {
            self::$classInstance = new self();
        }
        return self::$classInstance;
    }

    public function __construct()
    {
        $config = OW::getConfig();
        $un = ($config->configExists('iismagfa', 'panel_username')) ? $config->getValue('iismagfa', 'panel_username') : '';
        $pw = ($config->configExists('iismagfa', 'ws_password')) ? $config->getValue('iismagfa', 'ws_password') : '';
        $num = ($config->configExists('iismagfa', 'panel_number')) ? $config->getValue('iismagfa', 'panel_number') : '';
        $this->wsObj = new IISMAGFA_BOL_WebService($un, $pw, $num);
    }

    public function sendSMS(OW_Event $event)
    {
        $params = $event->getParams();
        if (!isset($params['mobile']))
            return null;
        if (!isset($params['text']))
            return null;

        $this->wsObj->enqueue($params['text'],$params['mobile']);

//        $this->wsObj->simpleEnqueueSample();
//        $this->wsObj->simpleEnqueueSample();
//        $this->wsObj->getAllMessagesSample();
//        $this->wsObj->getAllMessagesWithNumberSample();
//        $this->wsObj->getCreditSample();
//        $this->wsObj->getMessageIdSample();
//        $this->wsObj->getRealMessageStatusesSample();
    }

    public function SMSProviderSettingIsComplete(OW_Event $event)
    {
        $config = OW::getConfig();
        $result = ($config->configExists('iismagfa', 'panel_username')) &&
            ($config->configExists('iismagfa', 'ws_password')) &&
            ($config->configExists('iismagfa', 'panel_number'));
        $event->setData(array('is_complete' => $result));
    }

    public function getCredit()
    {
        $result = $this->wsObj->getCredit();
        return array('credit' => (int)$result);
    }
}
