<?php
/**
 * @author Issa Annamoradnejad <i.moradnejad@gmail.com>
 */
/**
 * Class : IISMAGFA_BOL_WebService
 */

class IISMAGFA_BOL_WebService {

    private  $USERNAME = "XXXXXXXXX";
    private  $PASSWORD = "XXXXXXXXX";
    private  $SEND_NUMBER = "XXXXXXXXX";
    private  $DOMAIN = "magfa";

    // base webservice url
    private $BASE_WEBSERVICE_URL = "http://sms.magfa.com/services/urn:SOAPSmsQueue?wsdl";

    private $client; // SoapClient object

    private $ERROR_MAX_VALUE = 1000;
    private $errors;

    private $outputSeparator = "\n";


    /**
     * method : constructor
     * the constructor method of the class
     * @return void
     */
    public function __construct($username, $password, $send_number){
        $this->USERNAME = $username;
        $this->PASSWORD = $password;
        $this->SEND_NUMBER = $send_number;

        if (PHP_SAPI !== 'cli')
        {
            // Pretty output
            $this->outputSeparator .= '<br>';
        }

        $this->errors = IISMAGFA_BOL_Errors::getErrors();
        try
        {
            $this->client = new SoapClient(
                $this->BASE_WEBSERVICE_URL,
                array(
                    'login' => $this->USERNAME,'password' => $this->PASSWORD, // Credientials
                    'features' => SOAP_USE_XSI_ARRAY_TYPE // Required
                    //,'trace' => true // Optional (debug)
                )
            );

            // Get list of functions
            //var_dump($this->client->__getFunctions());
        }
        catch (SoapFault $soapFault)
        {
            echo $soapFault.$this->outputSeparator;
        }
    }

    /**
     * @param $message
     * @param $number
     */
    public function enqueue($message, $number){
        $method = "enqueue"; // name of the service
        // creating the parameter array
        $params = array(
            'domain'=>$this->DOMAIN,
            'messageBodies'=>array($message),
            'recipientNumbers'=>array($number),
            'senderNumbers'=>array($this->SEND_NUMBER)
        );
        // sending the request via webservice
        $response = $this->call($method,$params);

        $result = $response[0];
        // compare the response with the ERROR_MAX_VALUE
        if ($result <= $this->ERROR_MAX_VALUE) {
            OW::getLogger()->writeLog(OW_Log::ERROR, 'magfa_enqueue', $this->errors[$result]);
        } 
    }

    public function getCredit(){
        $method = "getCredit"; // name of the service

        // creating the parameter array
        $params = array(
            'domain'=>$this->DOMAIN
        );

        // sending the request via webservice
        $response = $this->call($method,$params);

        return $response.$this->outputSeparator;
    }

    /**
     * method : simpleEnqueueSample
     * this method provides a sample usage of "enqueue" service in the simplest format (one receiver)
     * @return void
     */
    public function simpleEnqueueSample(){
        $method = "enqueue"; // name of the service
        $message = "Salam az Issa"; // [FILL] your message to send
        $recipientNumber = "09106946064"; // [FILL] recipient number; the mobile number which will receive the message (e.g 0912XXXXXXX)
        // creating the parameter array
        $params = array(
            'domain'=>$this->DOMAIN,
            'messageBodies'=>array($message),
            'recipientNumbers'=>array($recipientNumber),
            'senderNumbers'=>array($this->SEND_NUMBER)
        );
        // sending the request via webservice
        $response = $this->call($method,$params);

        $result = $response[0];
        // compare the response with the ERROR_MAX_VALUE
        if ($result <= $this->ERROR_MAX_VALUE) {
            echo "An error occured".$this->outputSeparator;
            echo "Error Code : $result ; Error Title : " . $this->errors[$result]['title'] . ' {' . $this->errors[$result]['desc'] . '}'.$this->outputSeparator;
        } else {
            echo "Message has been successfully sent ; MessageId : $result".$this->outputSeparator;
        }
    }

    /**
     * method : enqueueSample
     * this method provides a sample usage of "enqueue" service
     * @see simpleEnqueueSample()
     * @return void
     */
    public function enqueueSample(){
        $method = "enqueue"; // name of the service
        $message = "Salam az Issa"; // [FILL] your message to send
        // [FILL] recipient number; here we have multiple recipients (2)
        $recipientNumbers = array('09106946064'); // [FILL] you can add more items here ...
	    $checkingMessageIds = array(100, 101);

        // creating the parameter array
        $params = array(
            'domain'=>$this->DOMAIN,
            'messageBodies'=>array($message),
            'recipientNumbers'=>$recipientNumbers,
            'senderNumbers'=>array($this->SEND_NUMBER),
            'encodings'=>null,
            'udhs'=>null,
            'messageClasses'=>null,
            'priorities='>null,
            'checkingMessageIds'=>$checkingMessageIds
        );

        // sending the request via webservice
        $response = $this->call($method,$params);

        foreach($response as $result){
            // compare the response with the ERROR_MAX_VALUE
            if ($result <= $this->ERROR_MAX_VALUE) {
                echo "An error occured".$this->outputSeparator;
                echo "Error Code : $result ; Error Title : " . $this->errors[$result]['title'] . ' {' . $this->errors[$result]['desc'] . '}'.$this->outputSeparator;
            } else {
                echo "Message has been successfully sent ; MessageId : $result".$this->outputSeparator;
            }
        }
    }

    /**
     * method : getAllMessagesSample
     * this method provides a sample usage of "getAllMessages" service
     * @return void
     */
    public function getAllMessagesSample(){
        $method = "getAllMessages"; // name of the service
        $numberOfMessasges = 10; // [FILL] number of the messages to fetch

        // creating the parameter array
        $params = array(
            'domain'=>$this->DOMAIN,
            'numberOfMessages'=>$numberOfMessasges
        );

        // sending the request via webservice
        $response = $this->call($method,$params);

        if(count($response) == 0){
            echo "No new message".$this->outputSeparator;
        } else{
            // display the incoming message(s)
            foreach($response as $result){
                echo "Message:".$this->outputSeparator;
		        var_dump($result);
            }
        }
    }

    /**
     * method : getAllMessagesWithNumberSample
     * this method provides a sample usage of "getAllMessagesWithNumber" service
     * @return void
     */
    public function getAllMessagesWithNumberSample(){
        $method = "getAllMessagesWithNumber"; // name of the service
        $numberOfMessages = 10; // [FILL] number of the messages to fetch

        // creating the parameter array
        $params = array(
            'domain'=>$this->DOMAIN,
            'numberOfMessages'=>$numberOfMessages,
            'destNumber'=> $this->SEND_NUMBER
        );

        // sending the request via webservice
        $response = $this->call($method,$params);

        if(count($response) == 0){
            echo "No new message".$this->outputSeparator;
        } else{
            // display the incoming message(s)
            foreach($response as $result){
                echo "Message:".$this->outputSeparator;
		        var_dump($result);
            }
        }
    }

    /**
     * method : getCreditSample
     * this method provides a sample usage of "getCredit" service
     * @return void
     */
    public function getCreditSample(){
        $method = "getCredit"; // name of the service

        // creating the parameter array
        $params = array(
            'domain'=>$this->DOMAIN
        );

        // sending the request via webservice
        $response = $this->call($method,$params);

        // display the result
        echo 'Your Credit : '.$response.$this->outputSeparator;
    }

    /**
     * method : getMessageIdSample
     * this method provides a sample usage of "getMessageId" service
     * @return void
     */
    public function getMessageIdSample(){
        $method = "getMessageId"; // name of the service
        $checkingMessageId = 100; // [FILL] your checkingMessageId

        // creating the parameter array
        $params = array(
            'domain'=>$this->DOMAIN,
            'checkingMessageId'=>$checkingMessageId
        );

        // sending the request via webservice
        $result = $this->call($method,$params);

        // compare the response with the ERROR_MAX_VALUE
        if ($result <= $this->ERROR_MAX_VALUE) {
            echo "An error occured".$this->outputSeparator;
            echo "Error Code : $result ; Error Title : " . $this->errors[$result]['title'] . ' {' . $this->errors[$result]['desc'] . '}'.$this->outputSeparator;
        } else {
            echo "MessageId : $result".$this->outputSeparator;
        }
    }

    /**
     * method : getMessageStatusSample
     * this method provides a sample usage of "getMessageStatus" service
     * @return void
     */
    public function getMessageStatusSample(){
        $method = 'getMessageStatus'; // name of the service
        $messageId = 718570969; // [FILL] your messageId

        // creating the parameter array
        $params = array(
            'messageId'=>$messageId
        );

        //sending request via webservice
        $result = $this->call($method,$params);

        // checking the response
        if ($result == -1) {
            echo "An error occured".$this->outputSeparator;
            echo "Error Code : $result ; Error Title : " . $this->errors[$result]['title'] . ' {' . $this->errors[$result]['desc'] . '}'.$this->outputSeparator;
        } else {
            echo "Message Status : $result".$this->outputSeparator;
        }
    }

    /**
     * method : getMessageStatusesSample
     * this method provides a sample usage of "getMessageStatuses" service
     * @return void
     */
    public function getMessageStatusesSample(){
        $method = 'getMessageStatuses'; // name of the service
        // [FILL] an array of messageIds to check
        $messageIds = array(11728027728); //  [FILL] your messageID here

        // creating the parameter array
        $params = array(
            'messagesId'=>$messageIds
        );

        // sending the request via webservice
        $response = $this->call($method,$params);

        // checking the response
        foreach($response as $result){
            if ($result == -1) {
                echo "An error occured".$this->outputSeparator;
                echo "Error Code : $result ; Error Title : " . $this->errors[$result]['title'] . ' {' . $this->errors[$result]['desc'] . '}'.$this->outputSeparator;
            } else {
                echo "Message Status : $result".$this->outputSeparator;
            }
        }
    }

    /**
     * method : getRealMessageStatuses
     * this method provides a sample usage of "getRealMessageStatuses" service
     * @return void
     */
    public function getRealMessageStatusesSample(){
        $method = 'getRealMessageStatuses'; // name of the service
        // [FILL] an array of messageIds to check
        $messageIds = array(11728027728); // [FILL] your messageID here

        // creating the parameter array
        $params = array(
            'arg0'=>$messageIds
        );

        // sending the request via webservice
        $response = $this->call($method,$params);

        // checking the response
        foreach($response as $result){
            if ($result == -1) {
                echo "An error occured".$this->outputSeparator;
                echo "Error Code : $result ; Error Title : " . $this->errors[$result]['title'] . ' {' . $this->errors[$result]['desc'] . '}'.$this->outputSeparator;
            } else {
                echo "Message Status : $result".$this->outputSeparator;
            }
        }
    }

    /**
     * method : call
     * this method calls method of the webservice client object
     * @access private
     * @param  String $method    service name
     * @param  Array $params     webservice parameters in the form of an array
     * @return mixed             result
     */
    private function call($method,$params){
        try
        {
                $result = $this->client->__soapCall($method, $params);
        }
        catch (SoapFault $soapFault)
        {
                echo $soapFault . $this->outputSeparator;
                echo "REQUEST: " . $this->client->__getLastRequest() . $this->outputSeparator;
                echo "RESPONSE: " . $this->client->__getLastResponse() . $this->outputSeparator;
        }
        return $result;
    }

}
