<?php

/**
 * @author Issa Annamoradnejad <i.moradnejad@gmail.com>
 */
class IISMAGFA_CTRL_Admin extends ADMIN_CTRL_Abstract
{

    /**
     * IISMAGFA_CTRL_Admin constructor.
     */
    public function __construct()
    {
        parent::__construct();
        $language = OW::getLanguage();
        $this->setPageHeading($language->text('iismagfa', 'admin_settings_heading'));
        $this->setPageTitle($language->text('iismagfa', 'admin_settings_heading'));
        $this->setPageHeadingIconClass('ow_ic_gear_wheel');
    }

    public function index(array $params = array())
    {
        $currentSection = '1';

        if (array_key_exists('section', $params)) {
            $currentSection = $params['section'];
        }

        $language = OW::getLanguage();
        $config = OW::getConfig();

        if ($currentSection == '1') {
            $form = new Form('form');

            $field = new TextField('panel_username');
            $field->setRequired(true);
            $field->setLabel($language->text('iismagfa', 'panel_username'));
            if ($config->configExists('iismagfa', 'panel_username'))
                $field->setValue($config->getValue('iismagfa', 'panel_username'));
            $form->addElement($field);

            $field = new TextField('ws_password');
            $field->setRequired(true);
            $field->setLabel($language->text('iismagfa', 'ws_password'));
            if ($config->configExists('iismagfa', 'ws_password'))
                $field->setValue($config->getValue('iismagfa', 'ws_password'));
            $form->addElement($field);

            $field = new TextField('panel_number');
            $field->setRequired(true);
            $field->setLabel($language->text('iismagfa', 'panel_number'));
            if ($config->configExists('iismagfa', 'panel_number'))
                $field->setValue($config->getValue('iismagfa', 'panel_number'));
            $form->addElement($field);

            $submit = new Submit('save');
            $form->addElement($submit);

            $this->addForm($form);

            if (OW::getRequest()->isPost() && $form->isValid($_POST)) {
                $data = $form->getValues();

                if (!$config->configExists('iismagfa', 'panel_username'))
                    $config->addConfig('iismagfa', 'panel_username', $data['panel_username']);
                else
                    $config->saveConfig('iismagfa', 'panel_username', $data['panel_username']);

                if (!$config->configExists('iismagfa', 'ws_password'))
                    $config->addConfig('iismagfa', 'ws_password', $data['ws_password']);
                else
                    $config->saveConfig('iismagfa', 'ws_password', $data['ws_password']);

                if (!$config->configExists('iismagfa', 'panel_number'))
                    $config->addConfig('iismagfa', 'panel_number', $data['panel_number']);
                else
                    $config->saveConfig('iismagfa', 'panel_number', $data['panel_number']);

                OW::getFeedback()->info(OW::getLanguage()->text('iismagfa', 'modified_successfully'));
                $this->redirect();
            }
        }else{
            $page = 1;
            if(isset($_GET['page'])){
                $page = $_GET['page'];
            }
            $limit = 10;
            $tracks = IISMAGFA_BOL_TrackDao::getInstance()->findAllTracks($page,$limit);
            $resultTracks = array();
            foreach ($tracks as $track){
                $result = IISMAGFA_BOL_Service::getInstance()->checkSMSStatus($track->smsId);
                $resultTracks[] = array(
                    'text'=>$track->message,
                    'mobile'=>$track->mobile,
                    'time'=>$track->time,
                    'status'=>IISMAGFA_BOL_Service::getInstance()->getStatusString($result)
                );
            }
            $this->addComponent('paging', new BASE_CMP_Paging($page, ceil(IISMAGFA_BOL_TrackDao::getInstance()->findAllTrackCount() / $limit), 5));
            $this->assign('tracks', $resultTracks);
        }
        $this->assign('section',$currentSection);
        $this->assign('section1_label',OW::getLanguage()->text('iismagfa', 'section1_label'));
        $this->assign('section2_label',OW::getLanguage()->text('iismagfa', 'section2_label'));
        $this->assign('section1_url',OW::getRouter()->urlForRoute('iismagfa_admin_setting_section',array('section'=>1)));
        $this->assign('section2_url',OW::getRouter()->urlForRoute('iismagfa_admin_setting_section',array('section'=>2)));
    }

}