<?php
/**
 * iismainpage
 */
/**
 * @author Yaser Alimardany <yaser.alimardany@gmail.com>
 * @author Issa Annamoradnejad <i.moradnejad@gmail.com>
 * @package ow_plugins.iismainpage
 * @since 1.0
 */

class IISMAINPAGE_BOL_Service
{

    static $item_count = 20;

    /**
     * Constructor.
     */
    private function __construct()
    {
    }
    /**
     * Singleton instance.
     *
     * @var IISMAINPAGE_BOL_Service
     */
    private static $classInstance;

    /**
     * Returns an instance of class (singleton pattern implementation).
     *
     * @return IISMAINPAGE_BOL_Service
     */
    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    public function getMenu($type){
        $menus = array();
        $imgSource = OW::getPluginManager()->getPlugin('iismainpage')->getStaticUrl() . 'img/';

        $service = IISMAINPAGE_BOL_Service::getInstance();
        $orders = $service->getMenuOrder();

        $unreadGroupCount = (OW::getPluginManager()->isPluginActive('groups'))?GROUPS_BOL_Service::getInstance()->getUnreadGroupsCountForUser():0;
        $unreadChatCount = (OW::getPluginManager()->isPluginActive('mailbox'))?MAILBOX_BOL_ConversationService::getInstance()->getUnreadConversationsCount():0;

        $disables= $service->getDisabledList();

        foreach ($orders as $orderMenu) {
            if(($key = array_search($orderMenu, $disables)) !== false){
                continue;
            }
            if ($orderMenu =='dashboard' && OW::getPluginManager()->isPluginActive('newsfeed')) {
                $menu = array();
                $removeDashboardStatusForm = OW::getConfig()->getValue('newsfeed', 'removeDashboardStatusForm');
                $menu['title'] = $this->getLableOfMenu($orderMenu);
                $menu['iconUrl'] = $imgSource . 'dashboard.svg';
                $dashboardActiveClass = '';
                if (isset($removeDashboardStatusForm) && $removeDashboardStatusForm=="on") {
                    $menu['iconUrl'] = $imgSource . 'dashboard2.svg';
                }
                if ($type == 'dashboard') {
                    $menu['active'] = true;
                    $menu['iconUrl'] = $imgSource . 'dashboard_select.svg';
                    if (isset($removeDashboardStatusForm) && $removeDashboardStatusForm=="on") {
                        $menu['iconUrl'] = $imgSource . 'dashboard2_select.svg';
                        $dashboardActiveClass = ' removeDashboardStatusForm';
                    }

                } else {
                    $menu['active'] = false;
                }
                $menu['class'] = 'main_menu_dashboard'.$dashboardActiveClass;
                $menu['url'] = OW::getRouter()->urlForRoute('iismainpage.dashboard');
                $menus[] = $menu;
            }

            if ($orderMenu =='user-groups' && OW::getPluginManager()->isPluginActive('groups')) {
                $menu = array();
                $menu['title'] = $this->getLableOfMenu($orderMenu);
                $menu['iconUrl'] = $imgSource . 'groups.svg';
                if ($type == 'user-groups') {
                    $menu['active'] = true;
                    $menu['iconUrl'] = $imgSource . 'groups_select.svg';
                } else {
                    $menu['active'] = false;
                }
                $menu['class'] = 'main_menu_user_groups';
                $menu['url'] = OW::getRouter()->urlForRoute('iismainpage.user.groups');
                $menu['badgeNumber'] = $unreadGroupCount;
                $menus[] = $menu;
            }

            if ($orderMenu =='friends' && OW::getPluginManager()->isPluginActive('friends')) {
                $menu = array();
                $menu['title'] = $this->getLableOfMenu($orderMenu);
                $menu['iconUrl'] = $imgSource . 'friend.svg';
                if ($type == 'friends') {
                    $menu['active'] = true;
                    $menu['iconUrl'] = $imgSource . 'friend_select.svg';
                } else {
                    $menu['active'] = false;
                }
                $menu['class'] = 'main_menu_friends';
                $menu['url'] = OW::getRouter()->urlForRoute('iismainpage.friends');
                $menus[] = $menu;
            }

            if ($orderMenu =='mailbox' && OW::getPluginManager()->isPluginActive('mailbox')) {
                $menu = array();
                $menu['title'] = $this->getLableOfMenu($orderMenu);
                $menu['iconUrl'] = $imgSource . 'chat.svg';
                $menu['class'] = 'menu_messages';
                if ($type == 'mailbox') {
                    $menu['active'] = true;
                    $menu['iconUrl'] = $imgSource . 'chat_select.svg';
                } else {
                    $menu['active'] = false;
                }
                $menu['class'] = 'main_menu_mailbox';
                $menu['url'] = OW::getRouter()->urlForRoute('iismainpage.mailbox');
                $menu['badgeNumber'] = $unreadChatCount;
                $menus[] = $menu;
            }

            if($orderMenu =='settings'){
                $menu = array();
                $menu['title'] = $this->getLableOfMenu($orderMenu);
                $menu['iconUrl'] = $imgSource . 'Settings.svg';
                if ($type == 'settings') {
                    $menu['active'] = true;
                    $menu['iconUrl'] = $imgSource . 'Settings_select.svg';
                } else {
                    $menu['active'] = false;
                }
                $menu['class'] = 'main_menu_settings';
                $menu['url'] = OW::getRouter()->urlForRoute('iismainpage.settings');
                $menus[] = $menu;
           }

            if($orderMenu =='notifications'){
                $menu = array();
                $menu['title'] = $this->getLableOfMenu($orderMenu);
                $menu['iconUrl'] = $imgSource . 'notifications.svg';
                if ($type == 'notifications') {
                    $menu['active'] = true;
                    $menu['iconUrl'] = $imgSource . 'notifications_select.svg';
                } else {
                    $menu['active'] = false;
                }
                $menu['class'] = 'main_menu_notifications';
                $menu['url'] = OW::getRouter()->urlForRoute('iismainpage.notifications');

                if(OW::getUser()->isAuthenticated()) {
                    $userId = OW::getUser()->getId();
                    $badgeNumber = BOL_InvitationService::getInstance()->findInvitationCount($userId);
                    if (OW::getPluginManager()->isPluginActive('notifications')) {
                        $badgeNumber += NOTIFICATIONS_BOL_Service::getInstance()->findNotificationCount($userId, false);
                    }
                    if (OW::getPluginManager()->isPluginActive('friends')) {
                        $badgeNumber += FRIENDS_BOL_Service::getInstance()->countRequestsForUser();
                    }
                    $menu['badgeNumber'] = $badgeNumber;
                }
                $menus[] = $menu;
            }

            if($orderMenu =='photos'){
                $menu = array();
                $menu['title'] = $this->getLableOfMenu($orderMenu);
                $menu['iconUrl'] = $imgSource . 'photos.svg';
                if ($type == 'photos') {
                    $menu['active'] = true;
                    $menu['iconUrl'] = $imgSource . 'photos_select.svg';
                } else {
                    $menu['active'] = false;
                }
                $menu['class'] = 'main_menu_photos';
                $menu['url'] = OW::getRouter()->urlForRoute('iismainpage.photos');
                $menus[] = $menu;
            }

            if($orderMenu =='videos'){
                $menu = array();
                $menu['title'] = $this->getLableOfMenu($orderMenu);
                $menu['iconUrl'] = $imgSource . 'videos.svg';
                if ($type == 'videos') {
                    $menu['active'] = true;
                    $menu['iconUrl'] = $imgSource . 'videos_select.svg';
                } else {
                    $menu['active'] = false;
                }
                $menu['class'] = 'main_menu_videos';
                $menu['url'] = OW::getRouter()->urlForRoute('iismainpage.videos');
                $menus[] = $menu;
            }

            if($orderMenu =='chatGroups'){
                $menu = array();
                $menu['title'] = $this->getLableOfMenu($orderMenu);
                $menu['iconUrl'] = $imgSource . 'chatGroups.svg';
                if ($type == 'chatGroups') {
                    $menu['active'] = true;
                    $menu['iconUrl'] = $imgSource . 'chatGroups_select.svg';
                } else {
                    $menu['active'] = false;
                }
                $menu['class'] = 'main_menu_chatGroups';
                $menu['url'] = OW::getRouter()->urlForRoute('iismainpage.chatGroups');
                $menu['badgeNumber'] = $unreadGroupCount + $unreadChatCount;
                $menus[] = $menu;
            }
        }

        return $menus;
    }

    /***
     * @return array
     */
    public function getMenuOrder(){
        $orders = '';
        if(OW::getConfig()->configExists('iismainpage', 'orders')) {
            $orders = OW::getConfig()->getValue('iismainpage', 'orders');
        }
        $list = $orders!=''?json_decode(OW::getConfig()->getValue('iismainpage', 'orders')):null;
        if($list == null || (is_array($list) && empty($list)) || !is_array($list)){
            $list = $this->getMenuByDefaultOrder();
        }
        $new_list = array_merge($list, $this->getMenuByDefaultOrder());
        $new_list = array_unique($new_list);

        if($list != $new_list) {
            $this->savePageOrdered($new_list);
        }
        return $new_list;
    }
    /***
     * @return array
     */
    public function getMenuByDefaultOrder(){
        $list = array();
        $list[] = 'notifications';
        $list[] = 'user-groups';
        $list[] = 'dashboard';
        $list[] = 'friends';
        $list[] = 'mailbox';
        $list[] = 'photos';
        $list[] = 'videos';
        $list[] = 'settings';
        $list[] = 'chatGroups';
        return $list;
    }

    /***
     * @param $list
     */
    public function savePageOrdered($list){
        if(!OW::getConfig()->configExists('iismainpage','orders'))
        {
            OW::getConfig()->addConfig('iismainpage', 'orders', json_encode($list));
        }
        else {
            OW::getConfig()->saveConfig('iismainpage', 'orders', json_encode($list));
        }
    }

    public function getLableOfMenu($key){
        $languages = OW::getLanguage();
        if($key == 'dashboard'){
            return $languages->text('base', 'console_item_label_dashboard');
        }else if($key == 'user-groups'){
            return $languages->text('groups', 'group_list_menu_item_my');
        }else if($key == 'friends'){
            return $languages->text('friends', 'notification_section_label');
        }else if($key == 'mailbox'){
            return $languages->text('mailbox', 'messages_console_title');
        }else if($key == 'settings'){
            return $languages->text('iismainpage', 'settings');
        }else if($key == 'notifications'){
            return $languages->text('base', 'notifications');
        }else if($key == 'photos'){
            return $languages->text('iismainpage', 'public_photos');
        }else if($key == 'videos'){
            return $languages->text('video', 'video');
        }else if($key == 'chatGroups'){
            return $languages->text('iismainpage', 'chatGroups');
        }

        return '';
    }

    public function isPluginExist($key){
        if($key == 'dashboard'){
            return OW::getPluginManager()->isPluginActive('newsfeed');
        }else if($key == 'user-groups'){
            return OW::getPluginManager()->isPluginActive('groups');
        }else if($key == 'friends'){
            return OW::getPluginManager()->isPluginActive($key);
        }else if($key == 'mailbox'){
            return OW::getPluginManager()->isPluginActive($key);
        }else if($key == 'notifications'){
            return OW::getPluginManager()->isPluginActive($key);
        }else if($key == 'photos'){
            return OW::getPluginManager()->isPluginActive('photo');
        }else if($key == 'videos'){
            return OW::getPluginManager()->isPluginActive('video');
        }else if($key == 'chatGroups'){
            return OW::getPluginManager()->isPluginActive('mailbox') && OW::getPluginManager()->isPluginActive('groups');
        }

        return true;
    }

    public function addToDisableList($id)
    {
        $config = OW::getConfig();
        $disables = array();
        if(!$config->configExists('iismainpage', 'disables'))
        {
            $disables[]=$id;
            OW::getConfig()->addConfig('iismainpage', 'disables', json_encode($disables));
        }
        else {
            $disables = json_decode($config->getValue('iismainpage', 'disables'),true);
            if ( !in_array($id,$disables) ){
                $disables[] = $id;
                $config->saveConfig('iismainpage', 'disables', json_encode($disables));
            }
        }
    }

    public function addAsDefault($id)
    {
        $config = OW::getConfig();
        if(!$config->configExists('iismainpage', 'defaultPage'))
        {
            OW::getConfig()->addConfig('iismainpage', 'defaultPage', $id);
        }
        else {
            $config->saveConfig('iismainpage', 'defaultPage', $id);
        }
    }

    public function removeFromDisableList($id)
    {
        $config = OW::getConfig();
        if($config->configExists('iismainpage', 'disables'))
        {
            $disables = json_decode($config->getValue('iismainpage', 'disables'),true);
            if (($key = array_search($id, $disables)) !== false) {
                unset($disables[$key]);
            }
            if (sizeof($disables) == 0)
                $config->deleteConfig('iismainpage', 'disables');
            else
                $config->saveConfig('iismainpage', 'disables', json_encode($disables));
        }
    }

    public function getDisabledList(){
        $allItems = $this->getMenuByDefaultOrder();
        foreach ($allItems as $key){
            if(!$this->isPluginExist($key)){
                $this->addToDisableList($key);
            }
        }

        $disables = array();
        if(OW::getConfig()->configExists('iismainpage', 'disables')){
            $disables =  json_decode(OW::getConfig()->getValue('iismainpage', 'disables'),true);
            $disables = (is_array($disables))?$disables:[];
        }
        return $disables;
    }

    public function isDisabled($id){
        $disables = $this->getDisabledList();
        if (in_array($id,$disables)){
            return true;
        }
        return false;
    }

    public function findUserChatsAndGroups($userId,$first,$count=10,$q=null)
    {
        $dataArr = array();
        $groupService = GROUPS_BOL_Service::getInstance();
        if(isset($q))
        {
            $chatResult=MAILBOX_BOL_ConversationService::getInstance()->searchMessagesList($userId, $q);
            $tplList = GROUPS_BOL_GroupDao::getInstance()->findByUserId($userId, 0, $first+$count,null,$q,true);
        }
        else {
            $chatResult = MAILBOX_BOL_ConversationDao::getInstance()->findConversationItemListByUserId($userId, array('chat'), 0, $first + $count);
            $tplList = GROUPS_BOL_GroupDao::getInstance()->findByUserId($userId, 0, $first+$count,null,null,true);
        }
        $dataArr=array_merge($dataArr,$chatResult);
        $dataArr=array_merge($dataArr,$tplList);
        usort($dataArr, function($firstItem, $secondItem) {
            $firstItemLastMessageTimestamp = 0;
            if(isset($firstItem->lastActivityTimeStamp))
            {
                $firstItemLastMessageTimestamp=$firstItem->lastActivityTimeStamp;
            }else if (isset($firstItem['lastActivityTimeStamp'])){
                $firstItemLastMessageTimestamp=$firstItem['lastActivityTimeStamp'];
            }
            $secondItemLastMessageTimestamp = 0;
            if(isset($secondItem->lastActivityTimeStamp))
            {
                $secondItemLastMessageTimestamp=$secondItem->lastActivityTimeStamp;
            }else if (isset($secondItem['lastActivityTimeStamp'])){
                $secondItemLastMessageTimestamp=$secondItem['lastActivityTimeStamp'];
            }
            return $secondItemLastMessageTimestamp - $firstItemLastMessageTimestamp;
        });
        $dataArr = array_slice($dataArr,$first,$count);
        return $dataArr;
    }

    public function prepareChatGroupData($dataArr,$excludeData=array(),$q=null, $fetchLastGroupPost = true)
    {
        $tplList = array();
        $avatarService = BOL_AvatarService::getInstance();
        $groupIds = array();

        foreach($dataArr as $key => $value) {
            if ($value instanceof GROUPS_BOL_Group) {
                $groupIds[] = $value->id;
            }
        }

        $groupsUnreadCount = GROUPS_BOL_Service::getInstance()->getUnreadCountForEachGroupUser();
        $groupsUsersCountList = GROUPS_BOL_Service::getInstance()->findUserCountForList($groupIds);

        foreach($dataArr as $key => $value)
        {
            if($value instanceof GROUPS_BOL_Group)
            {
                $excludeData[]='group-'.$value->id;
                $userCount = 0;
                if (isset($groupsUsersCountList[$value->id])) {
                    $userCount = $groupsUsersCountList[$value->id];
                }
                $title = strip_tags($value->title);

                $toolbar = array(
                    array(
                        'label' => OW::getLanguage()->text('groups', 'listing_users_label', array(
                            'count' => $userCount
                        ))
                    )
                );

                $groupLastPost = $value->description;
                if ($fetchLastGroupPost) {
                    $lastPost = NEWSFEED_BOL_ActionDao::getInstance()->findByFeed('groups', $value->id, array(0, 1, false), null, null, null, null);
                    if ($lastPost != null && isset($lastPost[0]) && isset($lastPost[0]->data)) {
                        $groupLastPost = property_exists(json_decode($lastPost[0]->data), 'status') ? json_decode($lastPost[0]->data)->status : null;
                    }
                }
                $groupStatus = $groupLastPost ? $groupLastPost : $value->description;
                $stringRenderer = OW::getEventManager()->trigger(new OW_Event('emoji.before_render_string', array('string' => $groupStatus)));
                if (isset($stringRenderer->getData()['string'])) {
                    $groupStatus = ($stringRenderer->getData()['string']);
                }

                $eventPrepareGroup = OW::getEventManager()->trigger(new OW_Event('on.prepare.group.data',['parentGroupId'=>isset($value->parentGroupId)? $value->parentGroupId : null]));
                $parentTitle=null;
                if(isset($eventPrepareGroup->getData()['parentData'])){
                    $parentTitle = $eventPrepareGroup->getData()['parentData'];
                }

                $groupImageSource = GROUPS_BOL_Service::getInstance()->getGroupImageUrl($value);
                $unreadCount = 0;
                if (isset($groupsUnreadCount[$value->id])) {
                    $unreadCount = $groupsUnreadCount[$value->id];
                }
                $tplList[] = array(
                    'id' => $value->id,
                    'url' => OW::getRouter()->urlForRoute('groups-view', array('groupId' => $value->id)),
                    'title' => $title,
                    'imageTitle' => $title,
                    'content' => UTIL_String::truncate(strip_tags($groupStatus), 300, '...'),
                    'time' => UTIL_DateTime::formatDate($value->timeStamp),
                    'imageSrc' => $groupImageSource,
                    'imageInfo' => BOL_AvatarService::getInstance()->getAvatarInfo((int) $value->id, $groupImageSource),
                    'unreadCount' => $unreadCount,
                    'users' => $userCount,
                    'type' => 'group',
                    'lastActivityTimeStamp' => $value->lastActivityTimeStamp,
                    'toolbar' => $toolbar,
                    'parentTitle' => $parentTitle
                );
                continue;
            }
            $conversationItemList=array();
            if(!isset($q)) {
                $conversationItem = $value;
                $excludeData[] = 'chat-' . $value['id'];
                $conversationItem['timeStamp'] = (int)$value['initiatorMessageTimestamp'];
                $conversationItem['lastMessageSenderId'] = $value['initiatorMessageSenderId'];
                $conversationItem['isSystem'] = $value['initiatorMessageIsSystem'];
                $conversationItem['text'] = $value['initiatorText'];

                $conversationItem['lastMessageId'] = $value['initiatorLastMessageId'];
                $conversationItem['recipientRead'] = $value['initiatorRecipientRead'];
                $conversationItem['lastMessageRecipientId'] = $value['initiatorMessageRecipientId'];
                $conversationItem['lastMessageWasAuthorized'] = $value['initiatorMessageWasAuthorized'];
                $conversationItemList[] = $conversationItem;
                $conversationData = MAILBOX_BOL_ConversationService::getInstance()->getConversationItemByConversationIdListForApi( $conversationItemList );

            }else{
                $conversationItem = $this->prepareSearchedChatData($value);
                $conversationItemList[] = $conversationItem;
                $conversationData=$conversationItemList;
            }
            $tplList=array_merge($tplList,$conversationData);
        }

        return array('tplList'=>$tplList,'excludeData'=>$excludeData);
    }

    public function prepareSearchedChatData($item)
    {
        $avatarService = BOL_AvatarService::getInstance();
        $opponentId = $item['senderId'];
        if($opponentId == OW::getUser()->getId()){
            $opponentId = $item['recipientId'];
        }
        $convId = $item['conversationId'];
        $convIds[] = $convId;
        $item['opponentId']=$opponentId;
        $avatar = BOL_AvatarService::getInstance()->getAvatarUrl($opponentId);
        $item['avatarUrl']= isset($avatar) ? $avatar : $avatarService->getDefaultAvatarUrl(2);
        $item['opponentUrl']= BOL_UserService::getInstance()->getUserUrl($opponentId);
        $item['opponentName']= BOL_UserService::getInstance()->getDisplayName($opponentId);
        $item['text'] = MAILBOX_BOL_ConversationService::getInstance()->json_decode_text($item['text']);
        $item['timeString'] = UTIL_DateTime::formatDate((int)$item['timeStamp'], true);
        $item['mode'] = MAILBOX_BOL_ConversationService::getInstance()->getConversationMode((int)$convId);
        $item['unreadCount'] = MAILBOX_BOL_ConversationService::getInstance()->countUnreadMessagesForConversation((int)$convId, OW::getUser()->getId());
        if ($item['mode'] == 'chat') {
            $item['conversationUrl'] = OW::getRouter()->urlForRoute('mailbox_chat_conversation', array('userId'=>$opponentId));
        }else {
            $item['conversationUrl'] = OW::getRouter()->urlForRoute('mailbox_mail_conversation', array('convId'=>$convId));
        }
        return $item;
    }
    public function check_permission($action_name){
        $values = $this->getDisabledList();
        if (in_array($action_name, $values)){
            throw new Redirect404Exception();
        }
        return '';
    }
}