<?php
/**
 * Copyright (c) 2016, Yaser Alimardany
 * All rights reserved.
 */

/**
 *
 * @author Yaser Alimardany <yaser.alimardany@gmail.com>
 * @package ow_plugins.iismobileaccount.controllers
 * @since 1.0
 */
class IISMOBILEACCOUNT_CTRL_Admin extends ADMIN_CTRL_Abstract
{
    public function index($params)
    {
        $language = OW::getLanguage();
        $config = OW::getConfig();
        $this->setPageHeading(OW::getLanguage()->text('iismobileaccount', 'admin_settings_title'));
        $this->setPageTitle(OW::getLanguage()->text('iismobileaccount', 'admin_settings_title'));

        $form = new Form('setting');

        $field = new TextField('expired_cookie');
        $field->setLabel(ow::getLanguage()->text('iismobileaccount', 'expired_cookie'));
        $field->addValidator(new IntValidator());
        $field->setValue($config->getValue('iismobileaccount', 'expired_cookie'));
        $form->addElement($field);

        $field = new TextField('username_prefix');
        $field->setLabel(ow::getLanguage()->text('iismobileaccount', 'username_prefix'));
        $field->setValue($config->getValue('iismobileaccount', 'username_prefix'));
        $form->addElement($field);

        $field = new TextField('email_postfix');
        $field->setLabel(ow::getLanguage()->text('iismobileaccount', 'email_postfix'));
        $field->setValue($config->getValue('iismobileaccount', 'email_postfix'));
        $form->addElement($field);

        $field = new Selectbox('login_type_version');
        $field->setHasInvitation(false);
        $options = array(
            IISMOBILEACCOUNT_BOL_Service::BOTH_VERSION => $language->text('base', 'all'),
            IISMOBILEACCOUNT_BOL_Service::MOBILE_VERSION => $language->text('base', 'mobile_version_menu_item'),
            IISMOBILEACCOUNT_BOL_Service::DESKTOP_VERSION => $language->text('base', 'desktop_version_menu_item')
        );
        $field->setOptions($options);
        $field->setLabel(ow::getLanguage()->text('iismobileaccount', 'login_type_version'));
        $field->addValidator(new IntValidator());
        $field->setValue($config->getValue('iismobileaccount', 'login_type_version'));
        $form->addElement($field);

        $field = new Selectbox('join_type_version');
        $field->setHasInvitation(false);
        $options = array(
            IISMOBILEACCOUNT_BOL_Service::BOTH_VERSION => $language->text('base', 'all'),
            IISMOBILEACCOUNT_BOL_Service::MOBILE_VERSION => $language->text('base', 'mobile_version_menu_item'),
            IISMOBILEACCOUNT_BOL_Service::DESKTOP_VERSION => $language->text('base', 'desktop_version_menu_item')
        );
        $field->setOptions($options);
        $field->setLabel(ow::getLanguage()->text('iismobileaccount', 'join_type_version'));
        $field->addValidator(new IntValidator());
        $field->setValue($config->getValue('iismobileaccount', 'join_type_version'));
        $form->addElement($field);

        $field = new Selectbox('mandatory_email');
        $field->setHasInvitation(false);
        $options = array(
            0 => $language->text('iismobileaccount', 'optional'),
            1 => $language->text('iismobileaccount', 'mandatory')
        );
        $field->setOptions($options);
        $field->setLabel(ow::getLanguage()->text('base', 'ow_ic_mail'));
        $field->setValue($config->getValue('iismobileaccount', 'mandatory_email'));
        $form->addElement($field);

        $element = new Submit('submit');
        $form->addElement($element);

        if ( OW::getRequest()->isPost() ) {
            if ($form->isValid($_POST)) {
                $data = $form->getValues();
                $config->saveConfig('iismobileaccount', 'username_prefix', $data['username_prefix']);
                $config->saveConfig('iismobileaccount', 'email_postfix', $data['email_postfix']);
                $config->saveConfig('iismobileaccount', 'expired_cookie', $data['expired_cookie']);
                $config->saveConfig('iismobileaccount', 'login_type_version', $data['login_type_version']);
                $config->saveConfig('iismobileaccount', 'join_type_version', $data['join_type_version']);
                $config->saveConfig('iismobileaccount', 'mandatory_email', $data['mandatory_email']);
                OW::getFeedback()->info(OW::getLanguage()->text('iismobileaccount', 'saved_successfully'));
            }
        }

        $this->addForm($form);
    }
}