<?php
/**
 * Copyright (c) 2016, Yaser Alimardany
 * All rights reserved.
 */

/**
 *
 *
 * @author Yaser Alimardany <yaser.alimardany@gmail.com>
 * @package ow_plugins.iismobilesupport.bol
 * @since 1.0
 */
class IISMOBILESUPPORT_BOL_WebServiceMailbox
{
    private static $classInstance;

    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    private function __construct()
    {
    }

    public function getMessages(){
        if(!IISSecurityProvider::checkPluginActive('mailbox', true)){
            return array();
        }

        if(!OW::getUser()->isAuthenticated()){
            return array();
        }

        $count = IISMOBILESUPPORT_BOL_WebServiceGeneral::getInstance()->getPageSize();
        $userId = OW::getUser()->getId();
        return $this->processGetMessages($userId, $count);
    }

    public function processGetMessages($userId, $count){
        $data = array();
        $first = 0;
        if(isset($_GET['first'])){
            $first = (int) $_GET['first'];
        }
        $convList = MAILBOX_BOL_ConversationService::getInstance()->getConversationListByUserId($userId, $first, $count);
        foreach ($convList as $conv){
            $data[] = $this->preparedConversation($conv, $count, false);
        }

        return $data;
    }

    public function getUserMessage(){
        if(!IISSecurityProvider::checkPluginActive('mailbox', true)){
            return array();
        }

        if(!OW::getUser()->isAuthenticated()){
            return array();
        }

        $opponentId = null;
        if(isset($_GET['opponentId'])){
            $opponentId = $_GET['opponentId'];
        }

        if($opponentId == null){
            return array();
        }

        $userId = OW::getUser()->getId();
        $first = 0;
        $count = IISMOBILESUPPORT_BOL_WebServiceGeneral::getInstance()->getPageSize();
        if(isset($_GET['first'])){
            $first = (int) $_GET['first'];
        }

        return $this->processGetUserMessages($userId, $opponentId, $first, $count);
    }

    public function markUserMessage(){
        if(!IISSecurityProvider::checkPluginActive('mailbox', true)){
            return array('valid' => false);
        }

        if(!OW::getUser()->isAuthenticated()){
            return array('valid' => false);
        }

        $opponentId = null;
        if(isset($_GET['opponentId'])){
            $opponentId = $_GET['opponentId'];
        }

        if($opponentId == null){
            return array('valid' => false);
        }

        $userId = OW::getUser()->getId();

        $convId = MAILBOX_BOL_ConversationService::getInstance()->getChatConversationIdWithUserById($userId, $opponentId);
        $this->markMessages($convId, $userId);
        return array('valid' => true);
    }

    public function markMessages($convId, $userId) {
        if ($convId == null || $userId == null) {
            return;
        }
        $unreadMessages = MAILBOX_BOL_MessageDao::getInstance()->findUnreadMessagesForConversation($convId, $userId);
        $unreadMessagesId = array();
        foreach ($unreadMessages as $unreadMessage) {
            $unreadMessagesId[] = $unreadMessage->id;
        }
        if(!empty($unreadMessagesId)){
            MAILBOX_BOL_ConversationService::getInstance()->markMessageIdListRead($unreadMessagesId);
        }
    }

    public function processGetUserMessages($userId, $opponentId, $first, $count){
        $convId = MAILBOX_BOL_ConversationService::getInstance()->getChatConversationIdWithUserById($userId, $opponentId);
        $data = array();

        if($convId != null) {
            $convList = MAILBOX_BOL_ConversationService::getInstance()->getConversationListByUserId($userId, $first, $count, $convId);
            if($convList != null){
                $data = $this->preparedConversation($convList[0], $count);
                $this->markMessages($convId, $userId);
            }
        }
        return $data;
    }

    public function sendMessage(){
        $conversationService = MAILBOX_BOL_ConversationService::getInstance();
        if(!IISSecurityProvider::checkPluginActive('mailbox', true)){
            return array('valid' => false, 'message' => 'authorization_error');
        }

        if(!OW::getUser()->isAuthenticated()){
            return array('valid' => false, 'message' => 'authorization_error');
        }

        $opponentId = null;
        if(isset($_POST['opponentId'])){
            $opponentId = $_POST['opponentId'];
        }

        $text = null;
        if(isset($_POST['text'])){
            $text = $_POST['text'];
        }

        $userId = OW::getUser()->getId();
        if($userId == $opponentId || !isset($text) || $text == '' || $opponentId == null){
            return array('valid' => false, 'message' => 'authorization_error');
        }

        if(!is_numeric($opponentId)){
            return array('valid' => false, 'message' => 'input_error');
        }

        $conversation = null;
        $conversationId = $conversationService->getChatConversationIdWithUserById($userId, $opponentId);
        if ($conversationId == null || empty($conversationId)){
            $conversation = $conversationService->createChatConversation($userId, $opponentId);
            $conversationId = $conversation->getId();
        }

        $text = str_replace('↵',"\r\n", $text);
        $text = IISMOBILESUPPORT_BOL_WebServiceGeneral::getInstance()->stripString($text, false);
        $event = new OW_Event('mailbox.before_send_message', array(
            'senderId' => $userId,
            'recipientId' => $opponentId,
            'conversationId' => $conversationId,
            'message' => $text
        ), array('result' => true, 'error' => '', 'message' => $text ));
        OW::getEventManager()->trigger($event);

        $data = $event->getData();

        if ( !$data['result'] )
        {
            return array('valid' => false, 'message' => 'authorization_error');
        }

        $text = $data['message'];

        try
        {
            if($conversation == null && $conversationId != null){
                $conversation = MAILBOX_BOL_ConversationDao::getInstance()->findById($conversationId);
            }
            if($conversation == null){
                return array('valid' => false, 'message' => 'authorization_error');
            }
            $validFile = false;
            if(isset($_FILES) && isset($_FILES['file'])){
                $isFileClean = IISMOBILESUPPORT_BOL_WebServiceGeneral::getInstance()->isFileClean($_FILES['file']['tmp_name']);
                if ($isFileClean) {
                    $validFile = true;
                    $bundle = IISSecurityProvider::generateUniqueId();
                    $maxUploadSize = OW::getConfig()->getValue('base', 'attch_file_max_size_mb');
                    $validFileExtensions = json_decode(OW::getConfig()->getValue('base', 'attch_ext_list'), true);
                    BOL_AttachmentService::getInstance()->processUploadedFile('mailbox', $_FILES['file'], $bundle, $validFileExtensions, $maxUploadSize);
                    $items = BOL_AttachmentService::getInstance()->getFilesByBundleName('mailbox', $bundle);
                } else {
                    return array('valid' => false, 'message' => 'virus_detected');
                }
            }
            $replyId = null;
            if (isset($_POST['replyId'])) {
                $replyId = $_POST['replyId'];
            }
            $message = $conversationService->createMessage($conversation, $userId, $text, $replyId);
            if($validFile){
                MAILBOX_BOL_ConversationService::getInstance()->addMessageAttachments($message->id, $items);
            }
        }
        catch(InvalidArgumentException $e)
        {
            return array('valid' => false, 'message' => 'authorization_error');
        }


        $item = $conversationService->getRawMessageInfo($message);
        if(isset($_POST['_id']) && !empty($_POST['_id']) && $_POST['_id'] != null && $_POST['_id'] != "null"){
            $item['_id'] = $_POST['_id'];
        }else{
            $item['_id'] = $message->id;
        }
        return array('valid' => true, 'message'=>$item);
    }

    public function preparedConversation($conversationObj, $count, $returnMessages = true){
        $data = array();

        $conversationService = MAILBOX_BOL_ConversationService::getInstance();
        $data['conversation_info'] = array();

        $convInfo = array();
        if($conversationObj == null){
            return $data;
        }

        if (isset($conversationObj['opponentId']) && !isset($conversationObj['userId'])) {
            $conversationObj['userId'] = $conversationObj['opponentId'];
        }

        $convInfo['conversationId'] = (int) $conversationObj['conversationId'];
        $convInfo['user'] = IISMOBILESUPPORT_BOL_WebServiceUser::getInstance()->getUserInformationById($conversationObj['userId']);
        if (isset($convInfo['user'])) {
            $convInfo['user']['online'] = IISMOBILESUPPORT_BOL_WebServiceUser::getInstance()->isUserOnline($conversationObj['userId']);
        }
        $convInfo['preview_text'] = $conversationObj['previewText'];
        if (isset($conversationObj['originalPreviewText'])) {
            $convInfo['preview_text'] = $conversationObj['originalPreviewText'];
        }
        $convInfo['preview_text'] = IISMOBILESUPPORT_BOL_WebServiceGeneral::getInstance()->stripString($convInfo['preview_text'],true,false,true);
        $convInfo['last_time'] = $conversationObj['lastMessageTimestamp'];
        $convInfo['new_count'] = $conversationObj['newMessageCount'];
        if (isset($conversationObj['lastMessageRecipientId'])) {
            $convInfo['lastMessageRecipientId'] = (int) $conversationObj['lastMessageRecipientId'];
        }
        if (isset($conversationObj['recipientRead'])) {
            $convInfo['recipientRead'] = (bool) $conversationObj['recipientRead'];
        }
        $convInfo['mode'] = $conversationObj['mode'];

        $userId1 = (int) $conversationObj['userId'];
        $userId2 = (int) OW::getUser()->getId();
        if ($userId1 == $userId2 && isset($conversationObj['opponentId']) && $conversationObj['opponentId'] != $userId1) {
            $userId1 = (int) $conversationObj['opponentId'];
        }

        $blockInfo = IISMOBILESUPPORT_BOL_WebServiceGeneral::getInstance()->getBlockUsersInfo($userId2, $userId1);
        $convInfo['isBlocked'] = $blockInfo['isBlocked'];
        $convInfo['blockedBy'] = $blockInfo['blockedBy'];

        $data['conversation_info'] = $convInfo;
        if($returnMessages) {
            $data['messages'] = $this->getMessagesOfConversation($conversationObj['conversationId'], $count);
        }

        $editedMessages = array();
        $removedMessageIds = array();
        if(isset($_GET['existIds'])) {
            $existIds = $_GET['existIds'];
            $existIds = explode(',', $existIds);
            if (isset($existIds) && !empty($existIds) && sizeof($existIds) > 0) {
                foreach ($existIds as $existId) {
                    if (!empty($existId)) {
                        $message = MAILBOX_BOL_MessageDao::getInstance()->findById($existId);
                        if ($message && (int)$message->changed != 0) {
                            $editedMessages[] = $conversationService->getRawMessageInfo($message);
                        } else if($message == null) {
                            $removedMessageIds[] = (int) $existId;
                        }
                    }
                }
                if (sizeof($editedMessages) > 0) {
                    $data['editedMessages'] = $editedMessages;
                }
                if (sizeof($removedMessageIds) > 0) {
                    $data['removedMessageIds'] = $removedMessageIds;
                }
            }
        }

        return $data;
    }

    private function getMessagesOfConversation($conversationId, $count){
        $conversationService = MAILBOX_BOL_ConversationService::getInstance();
        $deletedTimestamp = $conversationService->getConversationDeletedTimestamp($conversationId);

        $dtoList = array();
        $list = array();
        if(isset($_GET['last_id'])){
            $dtoList = MAILBOX_BOL_MessageDao::getInstance()->findHistory($conversationId, $_GET['last_id'], $count, $deletedTimestamp);
            $dtoList = array_reverse($dtoList);
        }else{
            $unreadMessages = MAILBOX_BOL_MessageDao::getInstance()->findUnreadMessagesForConversation($conversationId, OW::getUser()->getId(), $deletedTimestamp);
            $minIdUnreadMessage = null;
            if (is_array($unreadMessages)) {
                foreach ($unreadMessages as $unreadMessage) {
                    if ($minIdUnreadMessage == null || $minIdUnreadMessage > $unreadMessage->id) {
                        $minIdUnreadMessage = $unreadMessage->id;
                    }
                }
            }
            if ($minIdUnreadMessage != null) {
                $dtoList = MAILBOX_BOL_MessageDao::getInstance()->findMessagesAfterMessageId($conversationId, $minIdUnreadMessage, $deletedTimestamp);
            } else {
                $dtoList = MAILBOX_BOL_MessageDao::getInstance()->findListByConversationId($conversationId, $count, $deletedTimestamp);
                $dtoList = array_reverse($dtoList);
            }
        }
        foreach($dtoList as $message)
        {
            $messageInfo = $conversationService->getRawMessageInfo($message);
            $list[] = $messageInfo;
        }

        return $list;
    }

    public function removeMessage() {
        if(!IISSecurityProvider::checkPluginActive('mailbox', true)){
            return array('valid' => false, 'message' => 'authorization_error');
        }

        $messageId = null;

        if(isset($_POST['id'])){
            $messageId = $_POST['id'];
        }

        if($messageId == null || !OW::getUser()->isAuthenticated()){
            return array('valid' => false, 'message' => 'authorization_error');
        }

        $done = MAILBOX_BOL_ConversationService::getInstance()->deleteMessage($messageId);
        if ($done){
            return array('valid' => true, 'id' => (int) $messageId);
        }

        return array('valid' => false, 'message' => 'authorization_error');
    }

    public function clearMessages() {
        if(!IISSecurityProvider::checkPluginActive('mailbox', true)){
            return array('valid' => false, 'message' => 'authorization_error');
        }

        $opponentId = null;

        if(isset($_POST['opponentId'])){
            $opponentId = $_POST['opponentId'];
        }

        if($opponentId == null || !OW::getUser()->isAuthenticated()){
            return array('valid' => false, 'message' => 'authorization_error');
        }

        $userId = OW::getUser()->getId();

        $conversationId = MAILBOX_BOL_ConversationService::getInstance()->getChatConversationIdWithUserById($userId, $opponentId);

        if (!isset($conversationId)) {
            return array('valid' => false, 'message' => 'authorization_error');
        }

        MAILBOX_BOL_ConversationService::getInstance()->deleteConversation(array($conversationId), $userId);

        return array('valid' => true, 'opponentId' => (int) $opponentId, 'conversationId' => (int) $conversationId);
    }

    public function editMessage() {
        if(!IISSecurityProvider::checkPluginActive('mailbox', true)){
            return array('valid' => false, 'message' => 'authorization_error');
        }

        $messageId = null;
        $text = null;

        if(isset($_POST['id'])){
            $messageId = $_POST['id'];
        }

        if(isset($_POST['text'])){
            $text = $_POST['text'];
        }

        if($text == null || $messageId == null || !OW::getUser()->isAuthenticated()){
            return array('valid' => false, 'message' => 'authorization_error');
        }

        $text = str_replace('↵',"\r\n", $text);
        $conversationService = MAILBOX_BOL_ConversationService::getInstance();
        $message = $conversationService->editMessage($messageId, $text);
        if ($message){
            if (isset($message->text)) {
                $message->text = $conversationService->json_decode_text($message->text);
            }
            $info = $conversationService->getRawMessageInfo($message);
            return array('valid' => true, 'message' => $info);
        }

        return array('valid' => false, 'message' => 'authorization_error');
    }
}