<?php
/**
 * iisquestionroles
 */
/**
 * @author Yaser Alimardani <yaser.alimardany@gmail.com>
 * @package ow_plugins.iisquestionroles
 * @since 1.0
 */

class IISQUESTIONROLES_BOL_Service
{
    private static $classInstance;
    
    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }
    
    private $questionRolesDao;
    
    private function __construct()
    {
        $this->questionRolesDao = IISQUESTIONROLES_BOL_QuestionRolesDao::getInstance();
    }

    /***
     * @return array
     */
    public function findAllRoles() {
        return $this->questionRolesDao->findAll();
    }

    /***
     * @param $id
     */
    public function deleteQuestionRole($id) {
        $this->questionRolesDao->deleteById($id);
    }

    public function getDisApprovedUsers($first = 0, $count = 21) {
        $currentQuestionsUserRoles = null;
        $viewAllUsers = false;
        if (OW::getUser()->isAuthenticated()) {
            if (OW::getUser()->isAdmin()) {
                $viewAllUsers = true;
            } else {
                $isAdmin = (BOL_AuthorizationService::getInstance()->isActionAuthorizedForUser(OW::getUser()->getId(), BOL_AuthorizationService::ADMIN_GROUP_NAME));
                if ($isAdmin) {
                    $viewAllUsers = true;
                } else {
                    $isBaseAdmin = (BOL_AuthorizationService::getInstance()->isActionAuthorizedForUser(OW::getUser()->getId(), 'base'));
                    if ($isBaseAdmin) {
                        $viewAllUsers = true;
                    }
                }
            }
            if (!$viewAllUsers) {
                $currentQuestionsUserRoles = $this->getUserRolesToManageSpecificUsers(OW::getUser()->getId());
            }
        }

        if ($currentQuestionsUserRoles == null && !$viewAllUsers) {
            return array('valid' => false);
        } else {
            $users = array();
            if ($viewAllUsers) {
                $usersObject = BOL_UserService::getInstance()->findUnapprovedList($first, $count);
                foreach ($usersObject as $userObject) {
                    $users[] = $userObject->id;
                }
                $allSize = BOL_UserService::getInstance()->countUnapproved();
            } else {
                $usersQuestionsData = $this->getUnapprovedUsersByRolesData($currentQuestionsUserRoles);
                $allUserIds = array();
                foreach ($usersQuestionsData as $userId => $userData) {
                    $allUserIds[] = $userId;
                }
                $ignoreUserIds = array();
                foreach ($usersQuestionsData as $userId => $userData) {
                    foreach ($currentQuestionsUserRoles as $questionRole) {
                        $qData = (array)json_decode($questionRole->data);
                        foreach ($qData as $key => $definedValue) {
                            if (isset($usersQuestionsData[$userId][$key])) {
                                $value = $usersQuestionsData[$userId][$key];
                                if ($value != $definedValue) {
                                    $ignoreUserIds[] = $userId;
                                }
                            }
                        }
                    }
                }
                $users = array_diff($allUserIds, $ignoreUserIds);
                $allSize = sizeof($users);
                $users = array_slice($users, $first, $count);
            }
            return array('valid' => true, 'users' => $users, 'allSize' => $allSize, 'hasLoadMore' => $allSize > $count);
        }
    }

    /***
     * @param null $userId
     * @return bool
     */
    public function hasAccessToRolesManagement($userId = null) {
        if ($userId == null && !OW::getUser()->isAuthenticated()) {
            return false;
        }
        if (OW::getUser()->isAdmin() || OW::getUser()->isAuthorized('iisquestionroles', 'manage_question_roles')) {
            return true;
        }
        return false;
    }

    public function getUserRoles($userId) {
        $aService = BOL_AuthorizationService::getInstance();
        $userRoles = $aService->findUserRoleList($userId);

        $userRolesIdList = array();
        foreach ( $userRoles as $role )
        {
            $userRolesIdList[] = $role->getId();
        }

        return $userRolesIdList;
    }

    /***
     * @param OW_Event $event
     */
    public function findModeratorForUser( OW_Event $event )
    {
        if (!OW::getUser()->isAuthenticated()) {
            return;
        }
        $params = $event->getParams();
        $userId = null;
        if (isset($params['userId'])) {
            $userId = $params['userId'];
        }

        if (isset($params['params']) && isset($params['params']['userId'])) {
            $userId = $params['params']['userId'];
        }

        if ($userId == null) {
            return;
        }

        if ($userId == 0) {
            return;
        }

        $moderatorIds = $event->getData();

        $allQuestionRoles = $this->questionRolesDao->findAll();
        if (empty($allQuestionRoles) || sizeof($allQuestionRoles) == 0) {
            return;
        }
        $validRoleIds = array();

        $questionsSectionsFetch = BOL_UserService::getInstance()->getUserViewQuestions($userId, true);
        foreach ($allQuestionRoles as $questionRole) {
            $qData = (array) json_decode($questionRole->data);

            $canManageUsers = true;
            foreach ($qData as $key => $definedValue){
                if(isset($_POST[$key])) {
                    if ($definedValue != $_POST[$key]) {
                        $canManageUsers = false;
                    }
                } else if(isset($questionsSectionsFetch['data'][$userId][$key])){
                    $value = $questionsSectionsFetch['data'][$userId][$key];
                    if (!isset($value[$definedValue])) {
                        $canManageUsers = false;
                    }
                }
            }
            if ($canManageUsers) {
                $validRoleIds[] = $questionRole->roleId;
            }
        }

        $usersId = BOL_AuthorizationUserRoleDao::getInstance()->findUsersByRoleIds($validRoleIds);
        foreach ($usersId as $userId){
            if (!in_array($userId->userId, $moderatorIds)) {
                $moderatorIds[] = $userId->userId;
            }
        }

        $event->setData($moderatorIds);
    }

    /***
     * @param OW_Event $event
     */
    public function hasUserAuthorizeToManageUsers( OW_Event $event )
    {
        if (!OW::getUser()->isAuthenticated()) {
            return;
        }
        $params = $event->getParams();
        $userId = null;
        if (isset($params['userId'])) {
            $userId = $params['userId'];
        }

        if (isset($params['params']) && isset($params['params']['userId'])) {
            $userId = $params['params']['userId'];
        }

        if ($userId == null) {
            return;
        }

        $currentUserId = OW::getUser()->getId();
        if (isset($params['currentUserId'])) {
            $currentUserId = $params['currentUserId'];
        }
        if ($userId == $currentUserId || $userId == 0) {
            return;
        }

        $currentUserRoles = $this->getUserRoles($currentUserId);
        if (empty($currentUserRoles) || sizeof($currentUserRoles) == 0) {
            return;
        }

        $questionRoles = $this->questionRolesDao->findByRoleIds($currentUserRoles);
        if (empty($questionRoles) || sizeof($questionRoles) == 0) {
            return;
        }

        $questionsSectionsFetch = BOL_UserService::getInstance()->getUserViewQuestions($userId, true);
        foreach ($questionRoles as $questionRole) {
            $qData = (array) json_decode($questionRole->data);

            $canManageUsers = true;
            foreach ($qData as $key => $definedValue){
                if(isset($_POST[$key])) {
                    if ($definedValue != $_POST[$key]) {
                        $canManageUsers = false;
                    }
                } else if(isset($questionsSectionsFetch['data'][$userId][$key])){
                    $value = $questionsSectionsFetch['data'][$userId][$key];
                    if (!isset($value[$definedValue])) {
                        $canManageUsers = false;
                    }
                } else if(!isset($questionsSectionsFetch['data'][$userId][$key])){
                        $canManageUsers = false;
                }
            }
            if ($canManageUsers) {
                $event->setData(array('valid' => true));
                return;
            }
        }

        $event->setData(array('valid' => false));
    }

    public function getUnapprovedUsersByRolesData($rolesData) {
        return $this->questionRolesDao->getUnapprovedUsersByRolesData($rolesData);
    }

    public function getUserRolesToManageSpecificUsers($userId)
    {
        if (!OW::getUser()->isAuthenticated()) {
            return null;
        }

        if ($userId == null) {
            return null;
        }

        $currentUserRoles = $this->getUserRoles($userId);
        if (empty($currentUserRoles) || sizeof($currentUserRoles) == 0) {
            return null;
        }

        $questionRoles = $this->questionRolesDao->findByRoleIds($currentUserRoles);
        if (empty($questionRoles) || sizeof($questionRoles) == 0) {
            return null;
        }

        return $questionRoles;
    }

    /***
     * @param BASE_CLASS_EventCollector $event
     */
    public function addRoleManagementConsoleItem( BASE_CLASS_EventCollector $event )
    {
        if($this->hasAccessToRolesManagement()) {
            $event->add(array('label' => OW::getLanguage()->text('iisquestionroles', 'console_label'), 'url' => OW_Router::getInstance()->urlForRoute('iisquestionroles.index')));
        }
    }

    public function getAllSystemRoles() {
        $authService = BOL_AuthorizationService::getInstance();
        $systemRolesData = array();
        $systemRolesList = $authService->getRoleList();

        foreach ( $systemRolesList as $role )
        {
            if($role->getName() != 'guest'){
                $systemRolesData[$role->getId()] = array(
                    'dto' => $role,
                    'roleFieldId' => 'role_'.$role->getId()
                );
            }
        }

        $tplRoles = array();
        foreach ( $systemRolesList as $role )
        {
            if($role->getName() != 'guest') {
                $tplRoles[$role->sortOrder] = $role;
            }
        }

        return array(
            'roles' => $tplRoles,
            'systemRolesData' => $systemRolesData,
        );
    }

    /***
     * @param $roleId
     * @param $data
     */
    public function saveRoleWithData($roleId, $data) {
        $this->questionRolesDao->saveRoleWithData($roleId, $data);
    }

    public function onNotifyActions(BASE_CLASS_EventCollector $e)
    {
        $e->add(array(
            'section' => 'iisquestionroles',
            'action' => 'manage_question_roles',
            'sectionIcon' => 'ow_ic_files',
            'sectionLabel' => OW::getLanguage()->text('iisquestionroles', 'admin_title'),
            'description' => OW::getLanguage()->text('iisquestionroles', 'console_label'),
            'selected' => true
        ));
    }

    public function onCollectAuthLabels( BASE_CLASS_EventCollector $event )
    {
        $language = OW::getLanguage();
        $event->add(
            array(
                'iisquestionroles' => array(
                    'label' => $language->text('iisquestionroles', 'admin_title'),
                    'actions' => array(
                        'manage_question_roles' => $language->text('iisquestionroles', 'console_label'),
                    )
                )
            )
        );
    }
}
