<?php
/**
 * iisquestionroles
 */
/**
 * @author Yaser Alimardani <yaser.alimardany@gmail.com>
 * @package ow_plugins.iisquestionroles
 * @since 1.0
 */

class IISQUESTIONROLES_CTRL_QuestionRoles extends OW_ActionController
{
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * @param null $params
     * @throws Redirect404Exception
     */
    public function index($params = NULL )
    {
        $service = IISQUESTIONROLES_BOL_Service::getInstance();
        if (!$service->hasAccessToRolesManagement()) {
            throw new Redirect404Exception();
        }

        $systemRolesInfo = $service->getAllSystemRoles();

        $lang = OW::getLanguage();
        $form = new Form('roles');

        $systemRolesOptions = array();
        foreach ($systemRolesInfo['roles'] as $role){
            $systemRolesOptions[$role->getId()] = $lang->text('base', 'authorization_role_'.$role->getName());
        }
        $field = new Selectbox('role');
        $field->setLabel($lang->text('iisquestionroles','select_role'));
        $field->addOptions($systemRolesOptions);
        $form->addElement($field);

        $allJoinQuestionsKey = array();
        $allSelectableQuestionElements = BOL_QuestionService::getInstance()->allSelectableQuestionElements();
        foreach ($allSelectableQuestionElements as $question){
            $qName = $question->getAttribute('name');
            $allJoinQuestionsKey[] = $qName;
            $qOptions = array();
            foreach ($question->getOptions() as $question_option_number=>$question_option){
                $qOptions[$question_option->questionName . '__' . $question_option->value] = OW::getLanguage()->text('base', 'questions_question_' . $question_option->questionName . '_value_' . $question_option->value);
            }
            $field = new Selectbox($qName);
            $question_label = OW::getLanguage()->text('base', 'questions_question_' . $question->getAttribute('name') . '_label');
            $field->setLabel($question_label);
            $field->addOptions($qOptions);
            $form->addElement($field);
        }

        $element = new Submit('save');
        $form->addElement($element);

        $this->addForm($form);
        $this->assign('allJoinQuestionsKey', $allJoinQuestionsKey);


        if (OW::getRequest()->isPost() && $form->isValid($_POST)) {
            $data = $form->getValues();
            $roleData = array();
            if (empty($data['role'])) {
                OW::getFeedback()->warning(OW::getLanguage()->text('iisquestionroles', 'role_empty'));
            } else {
                $allDataIsEmpty = true;
                foreach ($allSelectableQuestionElements as $question) {
                    $qName = $question->getAttribute('name');
                    if (!empty($data[$qName])) {
                        $allDataIsEmpty = false;
                    }
                }
                if ($allDataIsEmpty) {
                    OW::getFeedback()->warning(OW::getLanguage()->text('iisquestionroles', 'all_fields_empty'));
                } else {
                    foreach ($allSelectableQuestionElements as $question) {
                        $qName = $question->getAttribute('name');
                        if (!empty($data[$qName])) {
                            $qValue = substr($data[$qName], strlen($qName) + 2);
                            $roleData[$qName] = $qValue;
                        }
                    }
                    $service->saveRoleWithData($data['role'], json_encode($roleData));
                }
            }
        }

        $allDefinedRoles = $service->findAllRoles();
        $rolesDefinedInfo = array();
        foreach ($allDefinedRoles as $role){
            $roleName = $systemRolesInfo['systemRolesData'][$role->roleId]['dto']->name;
            $roleName = $lang->text('base', 'authorization_role_'.$roleName);
            $deleteUrl = OW::getRouter()->urlForRoute('iisquestionroles.delete', array('id' => $role->getId()));
            $rolesDefinedInfoTemp = array(
                'id' => $role->getId(),
                'roleId' => $role->roleId,
                'roleName' => $roleName,
                'deleteUrl' => $deleteUrl,
            );
            $data = (array) json_decode($role->data);

            $rolesDefinedInfoTemp['questions'] = array();
            foreach ($data as $key => $value){
                $rolesDefinedInfoTemp['questions'][] = array(
                    'title' => OW::getLanguage()->text('base', 'questions_question_' . $key . '_label'),
                    'value' => OW::getLanguage()->text('base', 'questions_question_' . $key . '_value_' . $value),
                );
            }

            $rolesDefinedInfo[] = $rolesDefinedInfoTemp;
        }

        $this->assign('rolesDefinedInfo', $rolesDefinedInfo);
        $plugin = OW::getPluginManager()->getPlugin('iisquestionroles');
        OW::getDocument()->addStyleSheet($plugin->getStaticCssUrl() . 'iisquestionroles.css');
        OW::getDocument()->addScript($plugin->getStaticJsUrl() . 'iisquestionroles.js');
        OW::getLanguage()->addKeyForJs('iisquestionroles', 'wait');
        OW::getLanguage()->addKeyForJs('iisquestionroles', 'are_you_sure_delete');
        $this->assign('deleteIconUrl', $plugin->getStaticUrl().'images/trash.svg');
    }

    /***
     * @param null $params
     * @throws Redirect404Exception
     */
    public function disapprovedUsers($params = null) {
        if (!OW::getUser()->isAuthenticated()) {
            throw new Redirect404Exception();
        }
        $page = (!empty($_GET['page']) && intval($_GET['page']) > 0 ) ? $_GET['page'] : 1;
        $rpp = (int) OW::getConfig()->getValue('base', 'users_count_on_page');

        $first = ($page - 1) * $rpp;
        $count = $rpp;

        $service = IISQUESTIONROLES_BOL_Service::getInstance();
        $usersInfo = $service->getDisApprovedUsers($first, $count);
        if ($usersInfo['valid'] == false) {
            throw new Redirect404Exception();
        }

        $idList = $usersInfo['users'];

        $this->setDocumentKey('disapproved_users ');

        $this->setPageHeading(OW::getLanguage()->text('iisquestionroles', 'users_disapproved'));
        $this->setPageTitle(OW::getLanguage()->text('iisquestionroles', 'users_disapproved'));
        $this->setPageHeadingIconClass('ow_ic_user');

        $itemCount = $usersInfo['allSize'];
        $this->addComponent('paging', new BASE_CMP_Paging($page, ceil($itemCount / $rpp), 5));

        $questionList = array();
        $avatarArr = array();
        $qs = array();

        $qBdate = BOL_QuestionService::getInstance()->findQuestionByName('birthdate');

        if ( $qBdate->onView ) {
            $qs[] = 'birthdate';
        }

        $qSex = BOL_QuestionService::getInstance()->findQuestionByName('sex');

        if ( $qSex->onView ) {
            $qs[] = 'sex';
        }

        if ( !empty($idList) )
        {
            $avatarArr = BOL_AvatarService::getInstance()->getDataForUserAvatars($idList, true, true, true, true, true);
            $questionList = BOL_QuestionService::getInstance()->getQuestionData($idList, $qs);
        }

        $list = BOL_UserService::getInstance()->findUserListByIdList($idList);
        $userList = array();
        foreach ( $list as $dto ) {
            $userList[] = array(
                'dto' => $dto
            );
        }
        $userFlatList = [];
        foreach ($userList as $userL){
            foreach($userL as $k => $v){
                $userFlatList[] = $v;
            }
        }

        $friendshipStatusEvent = OW::getEventManager()->trigger(new OW_Event(IISEventManager::USER_LIST_FRIENDSHIP_STATUS, array('list' =>    $userFlatList,'desktopVersion'=>true)));
        if(isset($friendshipStatusEvent->getData()['answerValues']) && sizeof($friendshipStatusEvent->getData()['answerValues'])>0){
            $this->assign('answerValues', $friendshipStatusEvent->getData()['answerValues']);
            $this->assign('questionNameList', $friendshipStatusEvent->getData()['questionNameList']);
            $this->assign('questionNameValues', $friendshipStatusEvent->getData()['questionNameValues']);
        }
        $this->assign('questionList', $questionList);
        $this->assign('avatars', $avatarArr);
        $this->assign('list', $userList);
    }

    /**
     * @param null $params
     * @throws Redirect404Exception
     */
    public function delete($params = NULL ){
        if (!isset($params['id'])) {
            throw new Redirect404Exception();
        }

        if (!OW::getRequest()->isAjax()) {
            throw new Redirect404Exception();
        }

        $service = IISQUESTIONROLES_BOL_Service::getInstance();
        if (!$service->hasAccessToRolesManagement()) {
            throw new Redirect404Exception();
        }
        $service->deleteQuestionRole($params['id']);
        exit();
    }
}
