<?php
class IISREPORT_MCLASS_EventHandler{
    private static $classInstance;

    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    private function __construct()
    {
    }

    public function init(){
        if( !IISSecurityProvider::checkPluginActive('groups', true) ){
            return;
        }

        $eventManager = OW::getEventManager();
        $eventManager->bind('base.add_main_console_item', array($this, 'addConsoleItem'));
        $eventManager->bind('admin.add_auth_labels', array($this, "onCollectAuthLabels"));
        $service = IISREPORT_BOL_Service::getInstance();
        $eventManager->bind('iis.add.group.category.filter.element',array($service,'onGroupCategoryElementAdded'));
        $eventManager->bind('iis.add.category.to.group',array($service,'onGroupCreated'));
        $eventManager->bind('iisgroupsplus.add.file.widget', array($service, 'addReportWidget'));
        $eventManager->bind('groups_group_delete_complete',array($service,'onGroupDeleted'));
    }

    public function onCollectAuthLabels( BASE_CLASS_EventCollector $event )
    {
        $language = OW::getLanguage();
        $event->add(
            array(
                'iisreport' => array(
                    'label' => $language->text('iisreport', 'auth_iisreport_label')
                )
            )
        );
    }
    public function addConsoleItem( BASE_CLASS_EventCollector $event )
    {
        if(OW::getUser()->isAuthorized('iisreport')){
            $event->add(array('label' => OW::getLanguage()->text('iisreport', 'console_reports_link'), 'url' => OW_Router::getInstance()->urlForRoute('report_overall')));

        }
    }


}