<?php
/**
 * Copyright (c) 2016, Yaser Alimardany
 * All rights reserved.
 */

/**
 *
 * @author Yaser Alimardany <yaser.alimardany@gmail.com>
 * @package ow_plugins.iisshasta.bol
 * @since 1.0
 */
class IISSHASTA_BOL_FileCategoryDao extends OW_BaseDao
{
    private static $classInstance;

    /***
     * @return IISSHASTA_BOL_FileCategoryDao
     */
    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    public function getDtoClassName()
    {
        return 'IISSHASTA_BOL_FileCategory';
    }
    
    public function getTableName()
    {
        return OW_DB_PREFIX . 'iisshasta_category';
    }

    /***
     * @param $name
     * @param $monthFilter
     * @param $yearFilter
     * @param null $id
     * @param $concept
     * @return IISSHASTA_BOL_FileCategory|null
     */
    public function saveCategory($name, $monthFilter, $yearFilter, $concept = 1, $id = null) {
        $category = null;
        if ($id != null) {
            $category = $this->findById($id);
        } else {
            $category = new IISSHASTA_BOL_FileCategory();
        }
        $category->name = $name;
        $category->monthFilter = $monthFilter;
        $category->yearFilter = $yearFilter;
        $category->concept = $concept;
        $this->save($category);
        return $category;
    }
}
