<?php
/**
 * Copyright (c) 2016, Yaser Alimardany
 * All rights reserved.
 */

/**
 *
 * @author Yaser Alimardany <yaser.alimardany@gmail.com>
 * @package ow_plugins.iisshasta.bol
 * @since 1.0
 */
class IISSHASTA_BOL_UserCategoriesDao extends OW_BaseDao
{
    private static $classInstance;

    /***
     * @return IISSHASTA_BOL_UserCategoriesDao
     */
    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    public function getDtoClassName()
    {
        return 'IISSHASTA_BOL_UserCategories';
    }
    
    public function getTableName()
    {
        return OW_DB_PREFIX . 'iisshasta_user_categories';
    }

    public function findByUser($userId = null) {
        if ($userId == null) {
            return null;
        }
        $example = new OW_Example();
        $example->andFieldEqual('userId', $userId);
        return $this->findObjectByExample($example);
    }

    public function saveCategories($userId, $categories) {
        $categoriesObject = $this->findByUser($userId);
        if ($categoriesObject == null) {
            $categoriesObject = new IISSHASTA_BOL_UserCategories();
        }
        $categoriesObject->categories = $categories;
        $categoriesObject->userId = $userId;
        $this->save($categoriesObject);
        return $categoriesObject;
    }
}
