<?php
/**
 * component class.
 *
 * @author Yaser Alimardany <yaser.alimardany@gmail.com>
 * @package ow_plugins.iisshasta.classes
 * @since 1.0
 */
class IISSHASTA_CMP_File extends OW_Component
{
    /**
     * IISSHASTA_CMP_File constructor.
     * @param $params
     * @throws Redirect404Exception
     */
    public function __construct($params = array())
    {
        parent::__construct();
        $fileId = $params['fileId'];
        $service = IISSHASTA_BOL_Service::getInstance();

        $file = $service->getFile($fileId);
        $filesData = $service->preparedFileItem($file);

        $this->assign('file', $filesData);
        $additionalId = 'default_widget';
        if (isset($params['additionalId'])) {
            $additionalId = $params['additionalId'];
        }
        $this->assign('additionalId', $additionalId);
        IISSHASTA_BOL_Service::getInstance()->addStaticFiles();
    }
}