<?php
/**
 * Copyright (c) 2017, Issa Annamoradnejad
 * All rights reserved.
 */

/**
 *
 * @author Issa Annamoradnejad <i.moradnejad@gmail.com>
 * @package ow_plugins.iissms.bol
 * @since 1.0
 */
class IISSMS_BOL_WaitlistDao extends OW_BaseDao
{
    private static $classInstance;

    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    public function getDtoClassName()
    {
        return 'IISSMS_BOL_Waitlist';
    }
    
    public function getTableName()
    {
        return OW_DB_PREFIX . 'iissms_waitlist';
    }

    public function findListByCount($max){
        $example = new OW_Example();
        $example->setOrder('`id` ASC');
        $example->setLimitClause(0, $max);
        return $this->findListByExample($example);
    }
}
