<?php
/**
 * Copyright (c) 2016, Hamed Tahmooresi
 * All rights reserved.
 */

/**
 *
 *
 * @author Hamed Tahmooresi <hamed.tahmooresi@gmail.com>
 * @package ow_plugins.iissso.bol
 * @since 1.0
 */
class IISSSO_BOL_LoggedoutTicketDao extends OW_BaseDao
{
    private static $classInstance;

    public static function getInstance()
    {
        if (self::$classInstance === null) {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    public function getDtoClassName()
    {
        return 'IISSSO_BOL_LoggedoutTicket';
    }

    public function getTableName()
    {
        return OW_DB_PREFIX . 'iissso_loggedout_ticket';
    }

    /***
     * @param $ticket
     * @param $cookie
     * @return IISSSO_BOL_LoggedoutTicket
     */
    public function addLoggedoutTicket($ticket)
    {
        $loggedoutTicket = new IISSSO_BOL_LoggedoutTicket();
        $loggedoutTicket->setTicket($ticket);
        $this->save($loggedoutTicket);
        return $loggedoutTicket;
    }

    public function deleteLoggedoutTicket($ticket){
        $example = new OW_Example();
        $example->andFieldEqual('ticket', $ticket);
        return $this->deleteByExample($example);
    }
    public function getLoggedoutTicket($ticket){
        $example = new OW_Example();
        $example->andFieldEqual('ticket', $ticket);
        return $this->findObjectByExample($example);
    }

}
