<?php
/**
 * Copyright (c) 2016, Hamed Tahmooresi
 * All rights reserved.
 */

/**
 *
 *
 * @author Hamed Tahmooresi <hamed.tahmooresi@gmail.com>
 * @package ow_plugins.iissso.classes
 * @since 1.0
 */
class IISSSO_CLASS_EventHandler
{
    private static $classInstance;

    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }


    private function __construct()
    {
    }

    public function genericInit()
    {
        $em = OW::getEventManager();
        $service = IISSSO_BOL_Service::getInstance();
        $em->bind(OW_EventManager::ON_PLUGINS_INIT, array($service, 'logoutUserIfRequired'));
        $em->bind(OW_EventManager::ON_PLUGINS_INIT, array($service, 'loginUserIfSSOLoggedIn'));
        $em->bind(IISEventManager::ON_BEFORE_SIGNIN_BUTTON_ADD, array($service, 'changeSignInButton'));
        $em->bind(IISEventManager::ON_BEFORE_JOIN_CONTROLLER_START, array($service, 'beforeJoinControllerStart'));
        $em->bind(IISEventManager::ON_BEFORE_SEND_VERIFICATION_EMAIL, array($service, 'beforeSendVerificationEmail'));
        $em->bind(OW_EventManager::ON_BEFORE_USER_REGISTER, array($service, 'setUsernameUsingSSOSession'));
        $em->bind(IISEventManager::ON_BEFORE_JOIN_FORM_RENDER, array($service, 'setEmailAndDisableUsername'));
        $em->bind(IISEventManager::ON_BEFORE_PROFILE_EDIT_FORM_BUILD, array($service, 'onBeforeProfileEditFormBuild'));
        $em->bind(IISEventManager::ON_AFTER_CHANGE_PASSWORD_WIDGET_ADDED, array($service, 'switchChangePasswordComponent'));
        $em->bind(IISEventManager::ON_BEFORE_FORM_SIGNIN_RENDER, array($service, 'onBeforeFormSigninRender'));

    }

    public function init()
    {
        $this->genericInit();
    }
}