<?php
/**
 * Copyright (c) 2016, Hamed Tahmooresi
 * All rights reserved.
 */

/**
 *
 * @author Hamed Tahmooresi <hamed.tahmooresi@gmail.com>
 * @package ow_plugins.iissso.controllers
 * @since 1.0
 */
class IISSSO_CTRL_Admin extends ADMIN_CTRL_Abstract
{
    public function index( array $params = array() )
    {
        $language = OW::getLanguage();
        $this->setPageHeading($language->text('iissso', 'admin_page_heading'));
        $this->setPageTitle($language->text('iissso', 'admin_page_title'));
        $config = OW::getConfig();
        $configs = $config->getValues('iissso');

        $form = new Form('settings');
        $form->setAjax();
        $form->setAjaxResetOnSuccess(false);
        $form->setAction(OW::getRouter()->urlForRoute('iissso.admin'));
        $form->bindJsFunction(Form::BIND_SUCCESS, 'function(data){if(data.result){OW.info("' . OW::getLanguage()->text("iissso", "settings_successfuly_saved") . '");}else{OW.error("Parser error");}}');

        $ssoUrl = new TextField('ssoUrl');
        $ssoUrl->setValue($configs['ssoUrl']);
        $ssoUrl->addAttribute('placeholder', 'http://sso.example.com');
        $ssoUrl->setLabel($language->text('iissso','ssoUrl'));
        $ssoUrl->setRequired();
        $form->addElement($ssoUrl);

        $ssoTicketValidationUrl = new TextField('ssoTicketValidationUrl');
        $ssoTicketValidationUrl->setValue($configs['ssoTicketValidationUrl']);
        $ssoTicketValidationUrl->setLabel($language->text('iissso','ssoTicketValidationUrl'));
        $ssoTicketValidationUrl->setRequired();
        $form->addElement($ssoTicketValidationUrl);


        $ssoLoginUrl = new TextField('ssoLoginUrl');
        $ssoLoginUrl->setValue($configs['ssoLoginUrl']);
        $ssoLoginUrl->setLabel($language->text('iissso','ssoLoginUrl'));
        $ssoLoginUrl->setRequired();
        $form->addElement($ssoLoginUrl);

        $ssoLogoutUrl = new TextField('ssoLogoutUrl');
        $ssoLogoutUrl->setValue($configs['ssoLogoutUrl']);
        $ssoLogoutUrl->setLabel($language->text('iissso','ssoLogoutUrl'));
        $ssoLogoutUrl->setRequired();
        $form->addElement($ssoLogoutUrl);

        $ssoRegistrationUrl = new TextField('ssoRegistrationUrl');
        $ssoRegistrationUrl->setValue($configs['ssoRegistrationUrl']);
        $ssoRegistrationUrl->setLabel($language->text('iissso','ssoRegistrationUrl'));
        $ssoRegistrationUrl->setRequired();
        $form->addElement($ssoRegistrationUrl);

        $ssoRegistrationUrl = new TextField('ssoChangePasswordUrl');
        $ssoRegistrationUrl->setValue($configs['ssoChangePasswordUrl']);
        $ssoRegistrationUrl->setLabel($language->text('iissso','ssoChangePasswordUrl'));
        $ssoRegistrationUrl->setRequired();
        $form->addElement($ssoRegistrationUrl);

        $ssoServerSecret = new TextField('ssoServerSecret');
        $ssoServerSecret->setValue($configs['ssoServerSecret']);
        $ssoServerSecret->setLabel($language->text('iissso','ssoServerSecret'));
        $ssoServerSecret->setRequired();
        $form->addElement($ssoServerSecret);

        $ssoClientSecret = new TextField('ssoClientSecret');
        $ssoClientSecret->setValue($configs['ssoClientSecret']);
        $ssoClientSecret->setLabel($language->text('iissso','ssoClientSecret'));
        $ssoClientSecret->setRequired();
        $form->addElement($ssoClientSecret);

        $ssoCookieKey = new TextField('ssoCookieKey');
        $ssoCookieKey->setValue($configs['ssoCookieKey']);
        $ssoCookieKey->setLabel($language->text('iissso','ssoCookieKey'));
        $ssoCookieKey->setRequired();
        $form->addElement($ssoCookieKey);

        $ssoSameDomain = new CheckboxField('ssoSameDomain');
        $ssoSameDomain->setValue($configs['ssoSameDomain']);
        $ssoSameDomain->setLabel($language->text('iissso','ssoSameDomain'));
        $form->addElement($ssoSameDomain);

        $autoRegisterUsers = new CheckboxField('autoRegisterUsers');
        $autoRegisterUsers->setValue($configs['autoRegisterUsers']);
        $autoRegisterUsers->setLabel($language->text('iissso','autoRegisterUsers'));
        $form->addElement($autoRegisterUsers);

        $autoRegisterUsers = new TextField('usersDetailsUrl');
        $autoRegisterUsers->setValue($configs['usersDetailsUrl']);
        $autoRegisterUsers->setLabel($language->text('iissso','usersDetailsUrl'));
        $form->addElement($autoRegisterUsers);

        $ssoCookieKey = new TextField('ssoSharedCookieDomain');
        $ssoCookieKey->setValue($configs['ssoSharedCookieDomain']);
        $ssoCookieKey->setLabel($language->text('iissso','ssoSharedCookieDomain'));
        $ssoCookieKey->setRequired();
        $form->addElement($ssoCookieKey);

        $submit = new Submit('save');
        $form->addElement($submit);

        $this->addForm($form);

        if ( OW::getRequest()->isAjax() )
        {
            if ( $form->isValid($_POST) )
            {
                $this->addOrEditConfig('iissso', 'ssoUrl', $form->getElement('ssoUrl')->getValue());
                $this->addOrEditConfig('iissso', 'ssoTicketValidationUrl', $form->getElement('ssoTicketValidationUrl')->getValue());
                $this->addOrEditConfig('iissso', 'ssoLoginUrl', $form->getElement('ssoLoginUrl')->getValue());
                $this->addOrEditConfig('iissso', 'ssoLogoutUrl', $form->getElement('ssoLogoutUrl')->getValue());
                $this->addOrEditConfig('iissso', 'ssoRegistrationUrl', $form->getElement('ssoRegistrationUrl')->getValue());
                $this->addOrEditConfig('iissso', 'ssoChangePasswordUrl', $form->getElement('ssoChangePasswordUrl')->getValue());
                $this->addOrEditConfig('iissso', 'ssoServerSecret', $form->getElement('ssoServerSecret')->getValue());
                $this->addOrEditConfig('iissso', 'ssoClientSecret', $form->getElement('ssoClientSecret')->getValue());
                $this->addOrEditConfig('iissso', 'ssoCookieKey', $form->getElement('ssoCookieKey')->getValue());
                $this->addOrEditConfig('iissso', 'ssoSameDomain', $form->getElement('ssoSameDomain')->getValue());
                $this->addOrEditConfig('iissso', 'autoRegisterUsers', $form->getElement('autoRegisterUsers')->getValue());
                $this->addOrEditConfig('iissso', 'ssoSharedCookieDomain', $form->getElement('ssoSharedCookieDomain')->getValue());
                $this->addOrEditConfig('iissso', 'usersDetailsUrl', $form->getElement('usersDetailsUrl')->getValue());
                IISSSO_BOL_Service::getInstance()->createMobileField();
                exit(json_encode(array('result' => true)));
            }
        }
    }
    private function addOrEditConfig($key, $name, $value){
        $config = OW::getConfig();
        if ($config->configExists($key,$name)){
            $config->saveConfig($key, $name, $value);
        }else{
            $config->addConfig($key, $name, $value);
        }
    }
}
