<?php
/**
 * Copyright (c) 2016, Hamed Tahmooresi
 * All rights reserved.
 */

/**
 *
 * @author Hamed Tahmooresi
 * @package ow_plugins.iissso.controllers
 * @since 1.0
 */
class IISSSO_CTRL_Controller extends OW_ActionController
{
    private $service;

    public function __construct()
    {
        $this->service = IISSSO_BOL_Service::getInstance();
        parent::__construct();
    }

    public function signIn(array $params = array())
    {
        if (OW::getUser()->isAuthenticated()) {
            throw new RedirectException(OW::getRouter()->getBaseUrl());
        }
        if ( !empty($_GET['back-uri']) )
        {
            $lastRequestPath = OW::getRouter()->getBaseUrl() . urldecode($_GET['back-uri']);
            IISSSO_BOL_Service::getInstance()->setLastRequestPath($lastRequestPath);
        }
        $loginUrl = OW_Config::getInstance()->getValue('iissso', 'ssoUrl') .
            OW_Config::getInstance()->getValue('iissso', 'ssoLoginUrl') .
            "?service=" . OW::getRouter()->getBaseUrl();
        $this->redirect($loginUrl);
    }

    public function signOut(array $params = array()){
        if (!IISSSO_BOL_Service::getInstance()->isLoggedInMember() && !IISSSO_BOL_Service::getInstance()->isSSOLoggedIn()) {
            throw new RedirectException(OW::getRouter()->getBaseUrl());
        }
        IISSSO_BOL_Service::getInstance()->logout();
        $logoutUrl = OW_Config::getInstance()->getValue('iissso', 'ssoUrl') .
            OW_Config::getInstance()->getValue('iissso', 'ssoLogoutUrl') .
            "?service=" . OW::getRouter()->getBaseUrl();
        $this->redirect($logoutUrl);
    }

    public function signInCallBack(array $params = array())
    {
        IISSSO_BOL_Service::getInstance()->checkUserAndAuthenticate($_REQUEST['ticket']);
        $redirectUrl = IISSSO_BOL_Service::getInstance()->getLastRequestPath();
        $this->redirect($redirectUrl);

    }
    public function signOutCallBack(array $params = array()){
        $ticket = isset($_POST['ticket']) ? $_POST['ticket'] : null;
        if($ticket){
            IISSSO_BOL_Service::getInstance()->addLoggedoutTicket($ticket);
        }
        exit(json_encode(array('status' => "ok")));
    }
}