<?php
/**
 * Copyright (c) 2016, Yaser Alimardany
 * All rights reserved.
 */

/**
 *
 * @author Yaser Alimardany <yaser.alimardany@gmail.com>
 * @package ow_plugins.iisstaticupdater.admin.controllers
 * @since 1.0
 */
class IISSTATICUPDATER_CTRL_Admin extends ADMIN_CTRL_Abstract
{
    public function index( array $params = array() )
    {
        $receiverFileID = rand(1,10000);
        $fileCode = IISSecurityProvider::generateUniqueId();
        $receiverLanguageID = rand(1,10000);
        $languageCode = IISSecurityProvider::generateUniqueId();
        $iisSecuritymanagerEvent= OW::getEventManager()->trigger(new OW_Event('iissecurityessentials.on.generate.request.manager',
            array('senderId'=>Ow::getUser()->getId(),'receiverId'=>$receiverFileID,'isPermanent'=>true,'activityType'=>'update_static_files')));
        if(isset($iisSecuritymanagerEvent->getData()['code'])){
            $fileCode = $iisSecuritymanagerEvent->getData()['code'];
        }
        $iisSecuritymanagerEvent= OW::getEventManager()->trigger(new OW_Event('iissecurityessentials.on.generate.request.manager',
            array('senderId'=>Ow::getUser()->getId(),'receiverId'=>$receiverLanguageID,'isPermanent'=>true,'activityType'=>'update_static_languages')));
        if(isset($iisSecuritymanagerEvent->getData()['code'])){
            $languageCode = $iisSecuritymanagerEvent->getData()['code'];
        }
        OW::getDocument()->setTitle(OW::getLanguage()->text('iisstaticupdater', 'admin_settings_title'));
        OW::getDocument()->setHeading(OW::getLanguage()->text('iisstaticupdater', 'admin_settings_title'));
        $staticUpdaterForm = new Form('setting');
        $staticUpdaterForm->setAction(OW::getRouter()->urlForRoute('update-all_static_files',array('fileCode'=>$fileCode)));
        $submitField = new Submit('submit');
        $staticUpdaterForm->addElement($submitField);
        $this->addForm($staticUpdaterForm);

        $staticLanguagesForm = new Form('languages');
        $staticLanguagesForm->setAction(OW::getRouter()->urlForRoute('update-languages',array('languageCode'=>$languageCode)));
        $submitField = new Submit('submit');
        $staticLanguagesForm->addElement($submitField);
        $this->addForm($staticLanguagesForm);

    }
}
