<?php
/**
 * Copyright (c) 2016, Yaser Alimardany
 * All rights reserved.
 */

/**
 *
 * @author Yaser Alimardany <yaser.alimardany@gmail.com>
 * @package ow_plugins.iisstaticupdater.controllers
 * @since 1.0
 */

class IISSTATICUPDATER_CTRL_Updater extends OW_ActionController
{

    public function updateStaticFiles($params){
        if(OW::getUser()->isAuthenticated() && OW::getUser()->isAdmin()){
            if(IISSecurityProvider::checkPluginActive('iissecurityessentials', true)) {
                $code =$params['fileCode'];
                if(!isset($code)){
                    throw new Redirect404Exception();
                }
                OW::getEventManager()->trigger(new OW_Event('iissecurityessentials.on.check.request.manager',
                    array('senderId' => OW::getUser()->getId(), 'code'=>$code,'activityType'=>'update_static_files')));
            }
            IISSecurityProvider::updateStaticFiles(true);
            OW::getFeedback()->info(OW::getLanguage()->text('iisstaticupdater', 'successfully_update'));
            $this->redirect(OW::getRouter()->urlForRoute('iisstaticupdater.admin'));
        }

        throw new Redirect404Exception();
    }

    public function updateLanguages($params){
        if(OW::getUser()->isAuthenticated() && OW::getUser()->isAdmin()){
            if(IISSecurityProvider::checkPluginActive('iissecurityessentials', true)) {
                $code =$params['languageCode'];
                if(!isset($code)){
                    throw new Redirect404Exception();
                }
                OW::getEventManager()->trigger(new OW_Event('iissecurityessentials.on.check.request.manager',
                    array('senderId' => OW::getUser()->getId(), 'code'=>$code,'activityType'=>'update_static_languages')));
            }
            try
            {
                IISSecurityProvider::updateLanguages(true);
                OW::getFeedback()->info(OW::getLanguage()->text('iisstaticupdater', 'update_language_successfully'));
                $this->redirect(OW::getRouter()->urlForRoute('iisstaticupdater.admin'));
            }
            catch (Exception $ex)
            {
                throw new Redirect404Exception();
            }
        }

        throw new Redirect404Exception();
    }
}