<?php
/**
 * Created by PhpStorm.
 * User: Elahe
 * Date: 6/24/2018
 * Time: 1:22 PM
 */

class IISTECHNOLOGY_CLASS_EventHandler
{
    private static $classInstance;

    public static function getInstance()
    {
        if (self::$classInstance === null) {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }


    private function __construct()
    {
    }

    public function addConsoleItem(BASE_CLASS_EventCollector $event)
    {
        if (OW::getUser()->isAuthorized('iistechnology', 'manage-technology')) {
            $event->add(array('label' => OW::getLanguage()->text('iistechnology', 'admin_technology_deactivates_page'), 'url' => OW_Router::getInstance()->urlForRoute('iistechnology.view-list',array('listType' => 'deactivate'))));
        }

    }
    public function onCollectAuthLabels( BASE_CLASS_EventCollector $event )
    {
        $language = OW::getLanguage();
        $event->add(
            array(
                'iistechnology' => array(
                    'label' => $language->text('iistechnology', 'auth_iistechnology_label'),
                    'actions' => array(
//                        'add_technology' => $language->text('iistechnology', 'auth_action_label_add_technology'),
//                        'view_technology' => $language->text('iistechnology', 'auth_action_label_view_technology'),
//                        'view_order' => $language->text('iistechnology', 'auth_action_label_view_order')
                        'manage-technology' => $language->text('iistechnology', 'auth_action_label_admin_technology')
                    )
                )
            )
        );
    }

    public function init()
    {
        $eventManager = OW::getEventManager();
        $eventManager->bind('base.add_main_console_item', array($this, 'addConsoleItem'));
        $eventManager->bind('admin.add_auth_labels', array($this, "onCollectAuthLabels"));
        $eventManager->bind('notifications.collect_actions', array($this, 'onNotifyActions'));
        $eventManager->bind(OW_EventManager::ON_BEFORE_DOCUMENT_RENDER, array($this, 'loadStaticFiles'));
    }

    public function onNotifyActions( BASE_CLASS_EventCollector $e )
    {
        $e->add(array(
            'section' => 'iistechnology',
            'action' => 'manage-technology',
            'description' => OW::getLanguage()->text('iistechnology', 'email_notifications_setting_comment'),
            'sectionIcon' => 'ow_ic_technology',
            'sectionLabel' => OW::getLanguage()->text('iistechnology', 'email_notifications_section_label'),
            'selected' => true
        ));
    }
    public function loadStaticFiles(){
        OW::getDocument()->addStyleSheet(OW::getPluginManager()->getPlugin('iistechnology')->getStaticCssUrl() . 'iistechnology.css');
        $path = $_SERVER['REQUEST_URI'];
        if(preg_match('#^(/(index(/){0,1}){0,1}){0,1}$#', $path, $matches))
        {
            $mainPageCssFile = OW::getPluginManager()->getPlugin('iistechnology')->getStaticCssUrl() . 'technology_mainpage.css';
            OW::getDocument()->addStyleSheet($mainPageCssFile);
        }
    }
}