<?php
/**
 * Created by PhpStorm.
 * User: Seyed Ismail Mirvakili
 * Date: 7/2/18
 * Time: 10:24 AM
 */

class IISTECHUNIT_CLASS_UrlMapping
{
    /**
     * Singleton instance.
     *
     * @var IISTECHUNIT_CLASS_UrlMapping
     */
    private static $classInstance;

    /**
     * Returns an instance of class (singleton pattern implementation).
     *
     * @return IISTECHUNIT_CLASS_UrlMapping
     */
    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    public function init(){
        OW::getRouter()->addRoute(new OW_Route('iistechunit.units', 'tech_units', "IISTECHUNIT_CTRL_Unit", 'index'));
        OW::getRouter()->addRoute(new OW_Route('iistechunit.search', 'tech_units/search', "IISTECHUNIT_CTRL_Unit", 'index'));
        OW::getRouter()->addRoute(new OW_Route('iistechunit.add_unit', 'tech_units/add_unit', "IISTECHUNIT_CTRL_Unit", 'addUnit'));
        OW::getRouter()->addRoute(new OW_Route('iistechunit.edit_unit', 'tech_units/edit_unit/:id', "IISTECHUNIT_CTRL_Unit", 'editUnit'));
        OW::getRouter()->addRoute(new OW_Route('iistechunit.delete_unit', 'tech_units/delete_unit/:id', "IISTECHUNIT_CTRL_Unit", 'deleteUnit'));
        OW::getRouter()->addRoute(new OW_Route('iistechunit.unit', 'tech_units/unit/:id', "IISTECHUNIT_CTRL_Unit", 'unit'));
        OW::getRouter()->addRoute(new OW_Route('iistechunit.admin', 'tech_units/admin', "IISTECHUNIT_CTRL_Admin", 'index'));
        OW::getRouter()->addRoute(new OW_Route('iistechunit.admin.edit', 'tech_units/admin/edit/:id', "IISTECHUNIT_CTRL_Admin", 'edit'));
        OW::getRouter()->addRoute(new OW_Route('iistechunit.admin.delete', 'tech_units/admin/delete/:id', "IISTECHUNIT_CTRL_Admin", 'delete'));
    }

    public function initMobile(){
        OW::getRouter()->addRoute(new OW_Route('iistechunit.units', 'tech_units', "IISTECHUNIT_MCTRL_Unit", 'index'));
        OW::getRouter()->addRoute(new OW_Route('iistechunit.search', 'tech_units/search', "IISTECHUNIT_MCTRL_Unit", 'index'));
        OW::getRouter()->addRoute(new OW_Route('iistechunit.add_unit', 'tech_units/add_unit', "IISTECHUNIT_MCTRL_Unit", 'addUnit'));
        OW::getRouter()->addRoute(new OW_Route('iistechunit.edit_unit', 'tech_units/edit_unit/:id', "IISTECHUNIT_MCTRL_Unit", 'editUnit'));
        OW::getRouter()->addRoute(new OW_Route('iistechunit.delete_unit', 'tech_units/delete_unit/:id', "IISTECHUNIT_MCTRL_Unit", 'deleteUnit'));
        OW::getRouter()->addRoute(new OW_Route('iistechunit.unit', 'tech_units/unit/:id', "IISTECHUNIT_MCTRL_Unit", 'unit'));
    }
}