<?php
/**
 * Created by PhpStorm.
 * User: Seyed Ismail Mirvakili
 * Date: 7/2/18
 * Time: 10:45 AM
 */

class IISTECHUNIT_CTRL_Unit extends OW_ActionController
{
    const COUNT = 10;

    public $service;

    public function __construct()
    {
        $this->service = IISTECHUNIT_BOL_Service::getInstance();
    }

    /**
     * @param $params
     * @throws Redirect404Exception
     */
    public function index($params)
    {
        if (!IISTECHUNIT_BOL_Service::getInstance()->hasViewAccess())
            throw new Redirect404Exception();
        if (isset($_GET['search']))
            $q = $_GET['search'];
        $form = new Form('search');
        $form->setMethod(Form::METHOD_GET);
        $form->setAction(OW_Router::getInstance()->urlForRoute('iistechunit.units'));

        $field = new TextField('search');
        $field->addValidator(new StringValidator(3));
        $field->setLabel(OW_Language::getInstance()->text('iistechunit', 'search'));
        $field->setInvitation(OW_Language::getInstance()->text('iistechunit', 'search'));
        $field->setHasInvitation(true);
        if (isset($q))
            $field->setValue($q);
        $form->addElement($field);

        $field = new Submit('submit');
        $field->setLabel(OW_Language::getInstance()->text('iistechunit', 'field_submit'));
        $form->addElement($field);

        if (isset($q)) {
            $unitsCount = IISTECHUNIT_BOL_UnitDao::getInstance()->searchCount($q);
            $page = (!empty($_GET['page']) && intval($_GET['page']) > 0) ? $_GET['page'] : 1;
            $units = IISTECHUNIT_BOL_Service::getInstance()->searchUnits($q, ($page - 1) * self::COUNT, self::COUNT);
            $this->loadUnits($units, $unitsCount, $page);
        } else {
            $unitsCount = IISTECHUNIT_BOL_UnitDao::getInstance()->countAll();
            $page = (!empty($_GET['page']) && intval($_GET['page']) > 0) ? $_GET['page'] : 1;
            $units = IISTECHUNIT_BOL_Service::getInstance()->loadUnits(($page - 1) * self::COUNT, self::COUNT);
            $this->loadUnits($units, $unitsCount, $page);
        }
        if (IISTECHUNIT_BOL_Service::getInstance()->hasAddAccess()) {
            $this->assign('add_url', OW::getRouter()->urlForRoute('iistechunit.add_unit'));
        }
        $this->addForm($form);
        $this->assign('originalUrl', OW::getRouter()->urlForRoute('iistechunit.search'));
        OW::getDocument()->addOnloadScript('
            window.searchUnits = function(url) {
                var query = $(\'#unitSearch\')[0].value;
                var filter = "?search="+query;
                url = url + filter;
                window.location = url;
            }
        ');
    }

    public function loadUnits($units, $unitsCount, $page)
    {
        $paging = new BASE_CMP_Paging($page, ceil($unitsCount / self::COUNT), 5);
        $this->addComponent('paging', $paging);
        $unitArray = array();
        /** @var IISTECHUNIT_BOL_Unit $unit */
        foreach ($units as $unit) {
            $websiteUrl = $unit->website;
            if (strpos($unit->website,'http://') === false || strpos($unit->website,'https://') === false){
                $websiteUrl = 'http://'.$unit->website;
            }
            $content =
                OW::getLanguage()->text('iistechunit','field_manager').': '.$unit->manager.'<br/>'.
                OW::getLanguage()->text('iistechunit','field_phone').': '.$unit->phone.'<br/>'.
                OW::getLanguage()->text('iistechunit','field_website').': '.'<a href="'.$websiteUrl.'" target="_blank">'.$unit->website.'</a>';
            $unitArray[] = array(
                'id' => $unit->id,
                'url' => OW::getRouter()->urlForRoute('iistechunit.unit', array('id' => $unit->id)),
                'title' => $unit->name,
                'imageTitle' => $unit->name,
                'content' => $content,
                'time' => UTIL_DateTime::formatDate($unit->timestamp),
                'imageSrc' => IISTECHUNIT_BOL_Service::getInstance()->getImageUrl($unit, $unit->image)
            );
        }
        $this->assign('list', $unitArray);
    }

    /**
     * @param $params
     * @throws Redirect404Exception
     */
    public function addUnit($params)
    {
        if (!IISTECHUNIT_BOL_Service::getInstance()->hasAddAccess())
            throw new Redirect404Exception();
        $form = new Form('add_unit');
        $form->setMethod(Form::METHOD_POST);
        $form->setEnctype(Form::ENCTYPE_MULTYPART_FORMDATA);
        $form->setAction(OW_Router::getInstance()->urlForRoute('iistechunit.add_unit'));

        $field = new TextField('name');
        $field->addValidator(new StringValidator(3, 128));
        $field->setLabel(OW_Language::getInstance()->text('iistechunit', 'field_name'));
        $field->setRequired(true);
        $form->addElement($field);

        $field = new FileField('image');
        $field->setLabel(OW_Language::getInstance()->text('iistechunit', 'field_image'));
        $field->setRequired(false);
        $form->addElement($field);

        $field = new FileField('qr_code');
        $field->setLabel(OW_Language::getInstance()->text('iistechunit', 'field_qr_code'));
        $field->setRequired(false);
        $form->addElement($field);

        $field = new TextField('manager');
        $field->addValidator(new StringValidator(3, 128));
        $field->setLabel(OW_Language::getInstance()->text('iistechunit', 'field_manager'));
        $field->setRequired(true);
        $form->addElement($field);

        $field = new TextField('address');
        $field->addValidator(new StringValidator(3, 512));
        $field->setLabel(OW_Language::getInstance()->text('iistechunit', 'field_address'));
        $field->setRequired(true);
        $form->addElement($field);

        $field = new TextField('phone');
        $field->addValidator(new StringValidator(3, 15));
        $field->setLabel(OW_Language::getInstance()->text('iistechunit', 'field_phone'));
        $field->setRequired(true);
        $form->addElement($field);

        $field = new TextField('email');
        $field->addValidator(new EmailValidator());
        $field->setLabel(OW_Language::getInstance()->text('iistechunit', 'field_email'));
        $field->setRequired(true);
        $form->addElement($field);

        $field = new TextField('website');
        $field->addValidator(new StringValidator(3, 256));
        $field->setLabel(OW_Language::getInstance()->text('iistechunit', 'field_website'));
        $field->setRequired(true);
        $form->addElement($field);

        if (OW::getConfig()->configExists('iistechunit', 'orders')) {
            $orderedList = json_decode(OW::getConfig()->getValue('iistechunit', 'orders'));
        } else {
            $orderedList = IISTECHUNIT_BOL_SectionDao::getInstance()->findIdListByExample(new OW_Example());
        }
        $sectionData = array();
        foreach ($orderedList as $item) {
            $section = IISTECHUNIT_BOL_SectionDao::getInstance()->findById($item);
            $buttons = array(
                BOL_TextFormatService::WS_BTN_BOLD,
                BOL_TextFormatService::WS_BTN_ITALIC,
                BOL_TextFormatService::WS_BTN_UNDERLINE,
                BOL_TextFormatService::WS_BTN_IMAGE,
                BOL_TextFormatService::WS_BTN_LINK,
                BOL_TextFormatService::WS_BTN_ORDERED_LIST,
                BOL_TextFormatService::WS_BTN_UNORDERED_LIST,
                BOL_TextFormatService::WS_BTN_MORE,
                BOL_TextFormatService::WS_BTN_SWITCH_HTML,
                BOL_TextFormatService::WS_BTN_HTML,
                BOL_TextFormatService::WS_BTN_VIDEO
            );
            $field = new WysiwygTextarea($section->name,'iistechunit',$buttons);
            $field->setLabel($section->title);
            $field->setRequired($section->required);
            $form->addElement($field);
            $sectionData[] = $section->name;
        }

        $field = new Submit('submit');
        $field->setLabel(OW_Language::getInstance()->text('iistechunit', 'field_submit'));
        $form->addElement($field);

        if (OW::getRequest()->isPost() && $form->isValid($_POST)) {
            $data = $form->getValues();

            $image = null;
            if (!empty($_FILES['image']['name'])) {
                if ((int)$_FILES['image']['error'] !== 0 || !is_uploaded_file($_FILES['image']['tmp_name']) || !UTIL_File::validateImage($_FILES['image']['name'])) {
                    OW::getFeedback()->error(OW::getLanguage()->text('base', 'not_valid_image'));
                    OW::getApplication()->redirect();
                } else {
                    $image = $this->service->addImage($_FILES['image']['tmp_name']);
                }
            }
            $qr_code = null;
            if (!empty($_FILES['qr_code']['name'])) {
                if ((int)$_FILES['qr_code']['error'] !== 0 || !is_uploaded_file($_FILES['qr_code']['tmp_name']) || !UTIL_File::validateImage($_FILES['qr_code']['name'])) {
                    OW::getFeedback()->error(OW::getLanguage()->text('base', 'not_valid_image'));
                    OW::getApplication()->redirect();
                } else {
                    $qr_code = $this->service->addImage($_FILES['qr_code']['tmp_name']);
                }
            }

            $sectionArray = array();
            foreach ($orderedList as $item) {
                $section = IISTECHUNIT_BOL_SectionDao::getInstance()->findById($item);
                $sectionArray[$section->id] = $data[$section->name];
            }
            IISTECHUNIT_BOL_Service::getInstance()->saveUnit($data['name'], $data['manager'], $image, $qr_code, $data['address'], $data['phone'], $data['email'], $data['website'], $sectionArray);
            OW::getFeedback()->info(OW::getLanguage()->text('iistechunit', 'success'));
            $this->redirect(OW::getRouter()->urlForRoute('iistechunit.units'));
        }
        $this->addForm($form);
        $this->assign('sections', $sectionData);
    }

    /**
     * @param $params
     * @throws Redirect404Exception
     */
    public function unit($params)
    {
        if (!IISTECHUNIT_BOL_Service::getInstance()->hasViewAccess())
            throw new Redirect404Exception();
        if (!isset($params['id']))
            throw new Redirect404Exception();
        $id = $params['id'];
        $unit = IISTECHUNIT_BOL_UnitDao::getInstance()->findById($id);
        $unitCmp = new IISTECHUNIT_CMP_Unit($unit);
        $this->addComponent('unitCmp', $unitCmp);
    }

    /**
     * @param $params
     * @throws Redirect404Exception
     */
    public function editUnit($params)
    {
        if (!IISTECHUNIT_BOL_Service::getInstance()->hasAddAccess())
            throw new Redirect404Exception();
        if (!isset($params['id']))
            throw new Redirect404Exception();
        $id = $params['id'];
        /** @var IISTECHUNIT_BOL_Unit $unit */
        $unit = IISTECHUNIT_BOL_UnitDao::getInstance()->findById($id);

        $form = new Form('edit_unit');
        $form->setMethod(Form::METHOD_POST);
        $form->setEnctype(Form::ENCTYPE_MULTYPART_FORMDATA);
        $form->setAction(OW_Router::getInstance()->urlForRoute('iistechunit.edit_unit', array('id' => $id)));

        $field = new TextField('name');
        $field->addValidator(new StringValidator(3, 128));
        $field->setLabel(OW_Language::getInstance()->text('iistechunit', 'field_name'));
        $field->setRequired(true);
        $field->setValue($unit->name);
        $form->addElement($field);

        $field = new FileField('image');
        $field->setLabel(OW_Language::getInstance()->text('iistechunit', 'field_image'));
        $field->setRequired(false);
        $form->addElement($field);

        $field = new FileField('qr_code');
        $field->setLabel(OW_Language::getInstance()->text('iistechunit', 'field_qr_code'));
        $field->setRequired(false);
        $form->addElement($field);

        $field = new TextField('manager');
        $field->addValidator(new StringValidator(3, 128));
        $field->setLabel(OW_Language::getInstance()->text('iistechunit', 'field_manager'));
        $field->setRequired(true);
        $field->setValue($unit->manager);
        $form->addElement($field);

        $field = new TextField('address');
        $field->addValidator(new StringValidator(3, 512));
        $field->setLabel(OW_Language::getInstance()->text('iistechunit', 'field_address'));
        $field->setRequired(true);
        $field->setValue($unit->address);
        $form->addElement($field);

        $field = new TextField('phone');
        $field->addValidator(new StringValidator(3, 15));
        $field->setLabel(OW_Language::getInstance()->text('iistechunit', 'field_phone'));
        $field->setRequired(true);
        $field->setValue($unit->phone);
        $form->addElement($field);

        $field = new TextField('email');
        $field->addValidator(new EmailValidator());
        $field->setLabel(OW_Language::getInstance()->text('iistechunit', 'field_email'));
        $field->setRequired(true);
        $field->setValue($unit->email);
        $form->addElement($field);

        $field = new TextField('website');
        $field->addValidator(new StringValidator(3, 256));
        $field->setLabel(OW_Language::getInstance()->text('iistechunit', 'field_website'));
        $field->setRequired(true);
        $field->setValue($unit->website);
        $form->addElement($field);

        if (OW::getConfig()->configExists('iistechunit', 'orders')) {
            $orderedList = json_decode(OW::getConfig()->getValue('iistechunit', 'orders'));
        } else {
            $orderedList = IISTECHUNIT_BOL_SectionDao::getInstance()->findIdListByExample(new OW_Example());
        }
        $sectionData = array();
        foreach ($orderedList as $item) {
            $section = IISTECHUNIT_BOL_SectionDao::getInstance()->findById($item);
            $buttons = array(
                BOL_TextFormatService::WS_BTN_BOLD,
                BOL_TextFormatService::WS_BTN_ITALIC,
                BOL_TextFormatService::WS_BTN_UNDERLINE,
                BOL_TextFormatService::WS_BTN_IMAGE,
                BOL_TextFormatService::WS_BTN_LINK,
                BOL_TextFormatService::WS_BTN_ORDERED_LIST,
                BOL_TextFormatService::WS_BTN_UNORDERED_LIST,
                BOL_TextFormatService::WS_BTN_MORE,
                BOL_TextFormatService::WS_BTN_SWITCH_HTML,
                BOL_TextFormatService::WS_BTN_HTML,
                BOL_TextFormatService::WS_BTN_VIDEO
            );
            $field = new WysiwygTextarea($section->name,'iistechunit',$buttons);
            $field->setLabel($section->title);
            $field->setRequired($section->required);
            $unitSections = IISTECHUNIT_BOL_UnitSectionDao::getInstance()->getUnitSections($unit->id, $section->id);
            foreach ($unitSections as $unitSection) {
                $field->setValue($unitSection->content);
                break;
            }
            $form->addElement($field);
            $sectionData[] = $section->name;
        }

        $field = new Submit('submit');
        $field->setLabel(OW_Language::getInstance()->text('iistechunit', 'field_submit'));
        $form->addElement($field);

        if (isset($unit->image)) {
            $this->assign('image', IISTECHUNIT_BOL_Service::getInstance()->getImageUrl($unit, $unit->image));
            $field = new CheckboxField('delete_image');
            $field->setLabel(OW_Language::getInstance()->text('iistechunit', 'delete_image'));
            $field->setRequired(false);
            $field->setValue(false);
            $form->addElement($field);
        }
        if (isset($unit->qr_code)) {
            $this->assign('qr_code', IISTECHUNIT_BOL_Service::getInstance()->getImageUrl($unit, $unit->qr_code));
            $field = new CheckboxField('delete_qr');
            $field->setLabel(OW_Language::getInstance()->text('iistechunit', 'delete_image'));
            $field->setRequired(false);
            $field->setValue(false);
            $form->addElement($field);
        }
        $this->assign('sections', $sectionData);
        $this->addForm($form);

        if (OW::getRequest()->isPost() && $form->isValid($_POST)) {
            $data = $form->getValues();

            $image = null;
            if (!empty($_FILES['image']['name'])) {
                if ((int)$_FILES['image']['error'] !== 0 || !is_uploaded_file($_FILES['image']['tmp_name']) || !UTIL_File::validateImage($_FILES['image']['name'])) {
                    OW::getFeedback()->error(OW::getLanguage()->text('base', 'not_valid_image'));
                    OW::getApplication()->redirect();
                } else {
                    $image = $this->service->addImage($_FILES['image']['tmp_name']);
                }
            }
            $qr_code = null;
            if (!empty($_FILES['qr_code']['name'])) {
                if ((int)$_FILES['qr_code']['error'] !== 0 || !is_uploaded_file($_FILES['qr_code']['tmp_name']) || !UTIL_File::validateImage($_FILES['qr_code']['name'])) {
                    OW::getFeedback()->error(OW::getLanguage()->text('base', 'not_valid_image'));
                    OW::getApplication()->redirect();
                } else {
                    $qr_code = $this->service->addImage($_FILES['qr_code']['tmp_name']);
                }
            }

            $sectionArray = array();
            foreach ($orderedList as $item) {
                $section = IISTECHUNIT_BOL_SectionDao::getInstance()->findById($item);
                $sectionArray[$section->id] = $data[$section->name];
            }
            $deleteImage = isset($data['delete_image']) && $data['delete_image'];
            $deleteQr = isset($data['delete_qr']) && $data['delete_qr'];
            IISTECHUNIT_BOL_Service::getInstance()->editUnit($id, $data['name'], $data['manager'], $image, $deleteImage, $qr_code, $deleteQr, $data['address'], $data['phone'], $data['email'], $data['website'], $sectionArray);
            OW::getFeedback()->info(OW::getLanguage()->text('iistechunit', 'success'));
            $this->redirect(OW::getRouter()->urlForRoute('iistechunit.unit', array('id' => $id)));
        }
    }

    /**
     * @param $params
     * @throws Redirect404Exception
     */
    public function deleteUnit($params)
    {
        if (!IISTECHUNIT_BOL_Service::getInstance()->hasAddAccess())
            throw new Redirect404Exception();
        if (!isset($params['id']))
            throw new Redirect404Exception();
        $id = $params['id'];
        IISTECHUNIT_BOL_UnitDao::getInstance()->deleteById($id);
        IISTECHUNIT_BOL_UnitSectionDao::getInstance()->deleteUnitSectionsByUnit($id);
        OW::getFeedback()->info(OW::getLanguage()->text('iistechunit', 'success'));
        $this->redirect(OW::getRouter()->urlForRoute('iistechunit.units'));
    }
}