<?php
/**
 * Created by PhpStorm.
 * User: Seyed Ismail Mirvakili
 * Date: 7/2/18
 * Time: 10:50 AM
 */

class IISTECHUNIT_MCMP_Unit extends OW_MobileComponent
{

    public $unit;

    /**
     * IISTECHUNIT_CMP_Unit constructor.
     * @param $unit
     */
    public function __construct($unit)
    {
        parent::__construct();
        $this->unit = $unit;
    }

    public function onBeforeRender()
    {
        parent::onBeforeRender();
        $unitSections = IISTECHUNIT_BOL_UnitSectionDao::getInstance()->getUnitSections($this->unit->id);
        if (OW::getConfig()->configExists('iistechunit', 'orders')) {
            $orderedList = json_decode(OW::getConfig()->getValue('iistechunit', 'orders'));
        }else{
            $orderedList = IISTECHUNIT_BOL_SectionDao::getInstance()->findIdListByExample(new OW_Example());
        }
        $sections = array();
        foreach ($orderedList as $item) {
            foreach ($unitSections as $unitSection) {
                if($unitSection->sectionId == $item){
                    $section = IISTECHUNIT_BOL_SectionDao::getInstance()->findById($unitSection->sectionId);
                    $sections[] = array(
                        'title' => $section->title,
                        'content' => $unitSection->content,
                    );
                }
            }
        }
        $websiteUrl = $this->unit->website;
        if (strpos($this->unit->website,'http://') === false || strpos($this->unit->website,'https://') === false){
            $websiteUrl = 'http://'.$this->unit->website;
        }
        $unitObject = array(
            'name' => $this->unit->name,
            'imagePath' => IISTECHUNIT_BOL_Service::getInstance()->getImageUrl($this->unit,$this->unit->image),
            'manager' => $this->unit->manager,
            'address' => $this->unit->address,
            'phone' => $this->unit->phone,
            'website' => $this->unit->website,
            'websiteUrl' => $websiteUrl,
            'email' => $this->unit->email,
            'sections' => $sections
        );
        if(isset($this->unit->qr_code)){
            $unitObject['qr_code'] = IISTECHUNIT_BOL_Service::getInstance()->getImageUrl($this->unit,$this->unit->qr_code);
        }
        $this->assign('unit',$unitObject);
        if(IISTECHUNIT_BOL_Service::getInstance()->hasAddAccess()){
            $this->assign('edit_url',OW::getRouter()->urlForRoute('iistechunit.edit_unit',array('id'=>$this->unit->id)));
            $this->assign('delete_url',OW::getRouter()->urlForRoute('iistechunit.delete_unit',array('id'=>$this->unit->id)));
        }
    }
}