<?php
/**
 * @author Milad Heshmati <milad.heshmati@gmail.com>
 * @package ow_plugins.iisthememanager
 * @since 1.0
 */

class IISTHEMEMANAGER_CLASS_EventHandler
{
    private static $classInstance;
    
    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }
    
    private function __construct()
    {
    }
    
    public function init()
    {
        $service = IISTHEMEMANAGER_BOL_Service::getInstance();
        $eventManager = OW::getEventManager();
        $eventManager->bind('iisthememanager.on.before.theme.style.renderer', array($service, 'getCustomTheme'));
        $eventManager->bind('iisthememanager.get.all.themes', array($service, 'getAllTheme'));
        $eventManager->bind('iisthememanager.on.before.document.render.add.footer.custom.tags', array($service, 'addFooterCustomTags'));
        $eventManager->bind('iisthememanager.update.all.child.themes.from.parent.theme', array($service, 'updateAllThemesList'));
    }
}